package ru.yandex.autotests.directapi.darkside.steps;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesBusinessType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesCreativeType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PerfCreativesRecord;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.BsFrontAuthResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.BsFrontChangeNotifyResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.BsFrontRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.BsFrontService;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.BsFrontTurbolandingRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.BsFrontTurbolandingResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.GetClientFeedsResponse;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.containsString;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class BsFrontSteps extends BaseJsonRpcSteps<BsFrontService> {

    @Step("Вызов BsFront.auth")
    public BsFrontAuthResponse auth(BsFrontRequest request) {
        return service().auth(request);
    }

    @Step("Вызов BsFront.change_notify")
    public List<BsFrontChangeNotifyResponse> changeNotify(BsFrontRequest request) {
        return service().change_notify(request);
    }


    @Step("Вызов BsFront.get_client_feeds")
    public List<GetClientFeedsResponse> getClientFeeds(BsFrontRequest request) {
        return service().get_client_feeds(request);
    }

    @Step("Вызов BsFront.get_client_feeds. operatorUid = {0}, clientLogin = {1}")
    public List<GetClientFeedsResponse> getClientFeeds(Integer operatorUid, String clientLogin) {
        return getClientFeeds(new BsFrontRequest().withOperatorUid(operatorUid).withClientLogin(clientLogin));
    }

    @Step("Вызов BsFront.auth с ожиданием ошибки")
    public void authExpectError(BsFrontRequest request, String errorMessage) {
        try {
            auth(request);
            throw new DarkSideException("Вызов завершен успешно");
        } catch (DarkSideException exception) {
            assertThat("текст ошибки совпадает", exception.getMessage(), containsString(errorMessage));
        }
    }

    @Step("Вызов BsFront.change_notify с ожиданием ошибки")
    public void changeNotifyExpectError(BsFrontRequest request, String errorMessage) {
        try {
            changeNotify(request);
            throw new DarkSideException("Вызов завершен успешно");
        } catch (DarkSideException exception) {
            assertThat("текст ошибки совпадает", exception.getMessage(), containsString(errorMessage));
        }
    }

    @Step("Вызов BsFront.turobolanding_change_notify ")
    public BsFrontTurbolandingResponse  turbolandingChangeNotify(BsFrontTurbolandingRequest request) {
        return service().turbolanding_change_notify(request);
    }

    public static PerfCreativesRecord getExpectedPerfCreativesRecord(Long clientId, Long creativeId,
                                                                     Long creativeGroupId) {
        return new PerfCreativesRecord()
                .setCreativeId(creativeId)
                .setStockCreativeId(creativeId)
                .setCreativeGroupId(creativeGroupId)
                .setClientid(clientId)
                .setBusinessType(PerfCreativesBusinessType.retail)
                .setCreativeType(PerfCreativesCreativeType.performance)
                .setName("testName")
                .setWidth((short) 240)
                .setHeight((short) 400)
                .setIsAdaptive(0)
                .setHasPackshot(0)
                .setHref("http://href-from-logo.ru/")
                .setStatusmoderate(PerfCreativesStatusmoderate.New)
                .setPreviewUrl("someString")
                .setModerateSendTime(new Timestamp(new Date().getTime()))
                .setModerateTryCount((short) 0)
                .setIsGenerated(0)
                .setTemplateId(0L)
                .setIsBannerstoragePredeployed(1);

    }

    public static PerfCreativesRecord getExpectedPerfCreativesElseRecord(Long clientId, Long creativeId,
                                                                         Long creativeGroupId) {
        return new PerfCreativesRecord()
                .setCreativeId(creativeId)
                .setStockCreativeId(creativeId)
                .setCreativeGroupId(creativeGroupId)
                .setClientid(clientId)
                .setBusinessType(PerfCreativesBusinessType.retail)
                .setCreativeType(PerfCreativesCreativeType.performance)
                .setName("test")
                .setWidth((short) 300)
                .setHeight((short) 250)
                .setIsAdaptive(0)
                .setHasPackshot(0)
                .setHref("http://somestring/")
                .setStatusmoderate(PerfCreativesStatusmoderate.New)
                .setPreviewUrl("someString")
                .setModerateSendTime(new Timestamp(new Date().getTime()))
                .setModerateTryCount((short) 0)
                .setIsGenerated(0)
                .setTemplateId(0L)
                .setIsBannerstoragePredeployed(1);
    }

    @Override
    protected BsFrontService initService() {
        return client().getServiceWithOneComplexParam(getServiceName(), getClazz());
    }

    @Override
    protected String getServiceName() {
        return BsFrontService.SERVICE_NAME;
    }

    @Override
    protected Class<BsFrontService> getClazz() {
        return BsFrontService.class;
    }
}
