package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.campaigninfo.CampaignInfoService;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.campaigninfo.GetCampaignInfoRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.campaigninfo.GetCampaignInfoResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.campaigninfo.GetCampaignManagerResponse;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

public class CampaignInfoSteps extends BaseJsonRpcSteps<CampaignInfoService> {

    @Step("Вызов метода CampaignInfo.getCampaignManager")
    public GetCampaignManagerResponse[] getCampaignManager(Long... cids) {
        return service().getCampaignManager(cids);
    }

    @Step("Вызов метода CampaignInfo.getCampaignInfo")
    public GetCampaignInfoResponse getCampaignInfo(GetCampaignInfoRequest request) {
        return service().getCampaignInfo(request);
    }

    @Override
    protected String getServiceName() {
        return CampaignInfoService.SERVICE_NAME;
    }

    @Override
    protected Class<CampaignInfoService> getClazz() {
        return CampaignInfoService.class;
    }
}
