package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.clientdata.ClientDataResponseItem;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.clientdata.ClientDataService;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;
import java.util.Map;

public class ClientDataSteps extends BaseJsonRpcSteps<ClientDataService> {

    @Step("Вызов метода get_by_ClientID: client_ids = {0}, mark_chief_reps = {1}")
    public Map<Long, ClientDataResponseItem> getByClientID(List<Long> clientIds, boolean mark_chief_reps) {
        return service().get_by_ClientID(clientIds, mark_chief_reps);
    }

    @Step("Вызов метода get_by_ClientID: client_ids = {0}, mark_chief_reps = {1}, fields = {2}")
    public Map<Long, ClientDataResponseItem> getByClientID(List<Long> clientIds, boolean mark_chief_reps, List<String> fields) {
        return service().get_by_ClientID(clientIds, mark_chief_reps, fields);
    }

    @Override
    protected String getServiceName() {
        return ClientDataService.SERVICE_NAME;
    }

    @Override
    protected Class<ClientDataService> getClazz() {
        return ClientDataService.class;
    }
}
