package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.darkside.clients.HttpResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.request.ClientsCreateRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.response.json.ClientsCreateErrorResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.response.json.ClientsCreateResponse;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.directapi.darkside.model.ClientsCreateError;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseHttpSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.core.IsNot.not;
import static ru.yandex.autotests.directapi.darkside.model.ClientsCreateError.ErrorEnum;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by hmepas on 27.03.17
 */
public class ClientsSteps extends BaseHttpSteps {
    final static String SERVICE_NAME = "clients";
    final static String METHOD_CREATE = SERVICE_NAME + "/create";

    @Step(value = "создаем клиента")

    public ClientsCreateResponse createManagerClient(String login, String managerLogin, Currency currency) {

        String country = null;
        if (currency.equals(Currency.RUB)) {
            country = "225";
        } else if (currency.equals(Currency.USD)) {
            country = "84";
        } else {
            throw new DarkSideException("Country is not defined");
        }
        ClientsCreateRequest clientRequest =ClientsCreateRequest.getDefaultClientCreateRequest()
                .withLogin(login)
                .withManagerLogin(managerLogin)
                .withCurrency(currency)
                .withCountry(country);
        final HttpResponse httpResponse =
                client().sendPostRequest(client().buildURIFromParams(METHOD_CREATE, clientRequest));
        assertThat("вернулся код 200", httpResponse.getCode(), equalTo(200));
        ClientsCreateResponse response = JsonUtils.getObject(httpResponse.getMessage(), ClientsCreateResponse.class);
        return response;
    }

    public ClientsCreateResponse createRandomRubClientNoErrors() {
        ClientsCreateRequest clientRequest = ClientsCreateRequest.getDefaultRandomLoginRubClientCreateRequest();
        final HttpResponse httpResponse =
                        client().sendPostRequest(client().buildURIFromParams(METHOD_CREATE, clientRequest));
        assertThat("вернулся код 200", httpResponse.getCode(), equalTo(200));
        ClientsCreateResponse response = JsonUtils.getObject(httpResponse.getMessage(), ClientsCreateResponse.class);
        return response;
    }

    public static String getServiceName() {
        return SERVICE_NAME;
    }

    @Step(value = "вызываем {method} ожидаем BadRequest")
    public String createClientExpectBadRequest(ClientsCreateRequest client) {
        final ClientsCreateError createError = createClientExpectError(METHOD_CREATE, client);
        assertThat("вернулась ошибка " + ErrorEnum.BAD_REQUEST.getErrorName(), createError.getErrorEnum(), equalTo(ErrorEnum.BAD_REQUEST));
        return createError.getMessage();
    }

    public ClientsCreateError createClientExpectError(String handle, ClientsCreateRequest clientRequest) {
        final HttpResponse httpResponse = client().sendPostRequest( client().buildURIFromParams(handle, clientRequest) );
        assertThat("вернулась ошибка, код ответа не равен 200", httpResponse.getCode(), not(200));
        assertThat("вернулcя известный код ошибки",
                ErrorEnum.errorCodes(), hasItem(httpResponse.getCode()));

        ClientsCreateErrorResponse response = JsonUtils.getObject(httpResponse.getMessage(), ClientsCreateErrorResponse.class);
        ClientsCreateError error = new ClientsCreateError(httpResponse.getCode(), response.getMessage());

        assertThat("код ошибки соответствует имени",
                error.getErrorEnum(),
                equalTo(ErrorEnum.byName(response.getError())));

        return error;
    }

}
