package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.currencyratesservice.CurrencyRatesService;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.currencyratesservice.YndFixedRatesItem;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.Map;

public class CurrencyRatesSteps extends BaseJsonRpcSteps<CurrencyRatesService> {

    @Step("[get_YND_FIXED_rates]")
    public Map<String, Map<String, YndFixedRatesItem>> getYndFixedRates() {
        return service().get_YND_FIXED_rates();
    }

    @Override
    protected String getServiceName() {
        return CurrencyRatesService.SERVICE_NAME;
    }

    @Override
    protected Class<CurrencyRatesService> getClazz() {
        return CurrencyRatesService.class;
    }
}
