package ru.yandex.autotests.directapi.darkside.steps;

import java.util.concurrent.ConcurrentHashMap;

import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.BaseSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.directapi.darkside.connection.BlackboxConfig;
import ru.yandex.autotests.directapi.darkside.connection.BmAPIConfig;
import ru.yandex.autotests.directapi.darkside.connection.GeoContextConfig;
import ru.yandex.autotests.directapi.darkside.connection.IntapiHttpConfig;
import ru.yandex.autotests.directapi.darkside.connection.IntapiHttpsConfig;
import ru.yandex.autotests.directapi.darkside.connection.IntapiJsonRPCConfig;
import ru.yandex.autotests.directapi.darkside.connection.IntapiJsonRestConfig;
import ru.yandex.autotests.directapi.darkside.connection.IntapiSecretJsonRPCConfig;
import ru.yandex.autotests.directapi.darkside.connection.IntapiSoapConfig;
import ru.yandex.autotests.directapi.darkside.connection.IntapiXmlRPCConfig;
import ru.yandex.autotests.directapi.darkside.steps.fakesteps.BannerPhrasesFakeSteps;
import ru.yandex.autotests.directapi.darkside.steps.fakesteps.BannersFakeSteps;
import ru.yandex.autotests.directapi.darkside.steps.fakesteps.CampaignFakeSteps;
import ru.yandex.autotests.directapi.darkside.steps.fakesteps.ClientFakeSteps;
import ru.yandex.autotests.directapi.darkside.steps.fakesteps.EventLogFakeSteps;
import ru.yandex.autotests.directapi.darkside.steps.fakesteps.FakeAdminSteps;
import ru.yandex.autotests.directapi.darkside.steps.fakesteps.GroupsFakeSteps;
import ru.yandex.autotests.directapi.darkside.steps.fakesteps.MailSmsFakeSteps;
import ru.yandex.autotests.directapi.darkside.steps.fakesteps.RetargetingFakeSteps;
import ru.yandex.autotests.directapi.darkside.steps.fakesteps.StatisticsFakeSteps;


public class DarkSideSteps {
    private IntapiHttpConfig httpConfig;
    private IntapiHttpsConfig httpsConfig;
    private IntapiJsonRPCConfig jsonRPCConfig;
    private IntapiJsonRestConfig jsonRestConfig;
    private IntapiSecretJsonRPCConfig secretJsonRPCConfig;
    private IntapiSoapConfig soapConfig;
    private IntapiXmlRPCConfig xmlRPCConfig;
    private BmAPIConfig bmAPIConfig = new BmAPIConfig();
    private GeoContextConfig geoContextConfig = new GeoContextConfig();
    private BlackboxConfig blackboxConfig = new BlackboxConfig();

    private DirectJooqDbSteps directJooqDbSteps;
    private ConcurrentHashMap<Integer, DirectJooqDbSteps> shardedDirectJooqDbSteps = new ConcurrentHashMap<>();
    //после DIRECT-64475 адрес, по которому надо обращаться к intapi и адрес, на который должен ходить jooq - отличаются.
    private String intapiUrl;

    public DarkSideSteps() {
        intapiUrl = DirectTestRunProperties.getInstance().getDirectIntapiHost();

        httpConfig = new IntapiHttpConfig();
        httpsConfig = new IntapiHttpsConfig();
        jsonRPCConfig = new IntapiJsonRPCConfig();
        jsonRestConfig = new IntapiJsonRestConfig();
        secretJsonRPCConfig = new IntapiSecretJsonRPCConfig();
        soapConfig = new IntapiSoapConfig();
        xmlRPCConfig = new IntapiXmlRPCConfig();
    }

    /**
     * Is used for intapi monitoring. Creates instance of DarkSideSteps with predifened intapi host
     */
    public DarkSideSteps(String predifinedHost) {
        this(DirectTestRunProperties.newInstance().withPredefinedIntapiHost(predifinedHost));
    }

    public DarkSideSteps(DirectTestRunProperties runProperties) {
        intapiUrl = runProperties.getDirectIntapiHost();

        httpConfig = new IntapiHttpConfig(intapiUrl);
        httpsConfig = new IntapiHttpsConfig(intapiUrl);
        jsonRPCConfig = new IntapiJsonRPCConfig(intapiUrl);
        jsonRestConfig = new IntapiJsonRestConfig(intapiUrl);
        secretJsonRPCConfig = new IntapiSecretJsonRPCConfig(intapiUrl);
        soapConfig = new IntapiSoapConfig(intapiUrl);
        xmlRPCConfig = new IntapiXmlRPCConfig(intapiUrl);
    }

    public String getHost() {
        return intapiUrl;
    }

    public DarkSideSteps setBmAPIHost(String url) {
        bmAPIConfig.setHost(url);
        return this;

    }

    public DarkSideSteps setGeoContextHost(String url) {
        geoContextConfig.setHost(url);
        return this;

    }

    public FileStorageSteps getFileStorageSteps() {

        return BaseSteps.getInstance(FileStorageSteps.class, httpConfig);
    }

    public MetricaOldTransportSteps getMetricaOldTransportSteps() {
        return BaseSteps.getInstance(MetricaOldTransportSteps.class, httpConfig);
    }

    public RunScriptSteps getRunScriptSteps() {
        return BaseSteps.getInstance(RunScriptSteps.class, jsonRPCConfig);
    }

    public DostupSteps getDostupSteps() {
        return BaseSteps.getInstance(DostupSteps.class, httpsConfig);
    }

    public AutobudgetAlertsSteps getAutobudgetAlertsSteps() {
        return BaseSteps.getInstance(AutobudgetAlertsSteps.class, jsonRPCConfig);
    }

    public BalanceClientNotifyOrderJsonSteps getBalanceClientNotifyOrderJsonSteps() {
        return BaseSteps.getInstance(BalanceClientNotifyOrderJsonSteps.class, jsonRestConfig);
    }

    public BalanceClientNotifyClientJsonSteps getBalanceClientNotifyClientJsonSteps() {
        return BaseSteps.getInstance(BalanceClientNotifyClientJsonSteps.class, jsonRestConfig);
    }

    public BalanceClientNotifyCashbackJsonSteps getBalanceClientNotifyCashbackJsonSteps() {
        return BaseSteps.getInstance(BalanceClientNotifyCashbackJsonSteps.class, jsonRestConfig);
    }

    public BalanceClientNotifyAgencyAdditionalCurrenciesJsonSteps getBalanceClientNotifyAgencyAdditionalCurrenciesJsonSteps() {
        return BaseSteps.getInstance(BalanceClientNotifyAgencyAdditionalCurrenciesJsonSteps.class, jsonRestConfig);
    }

    public BsExportSteps getBsExportSteps() {
        return BaseSteps.getInstance(BsExportSteps.class, jsonRestConfig);
    }

    public SoapClientSteps getSoapClientSteps() {
        return BaseSteps.getInstance(SoapClientSteps.class, soapConfig);
    }

    public FakeAdminSteps fakeAdminSteps() {
        return BaseSteps.getInstance(FakeAdminSteps.class, secretJsonRPCConfig);
    }

    public BannersFakeSteps getBannersFakeSteps() {
        return BaseSteps.getInstance(BannersFakeSteps.class, secretJsonRPCConfig);
    }

    public BannerPhrasesFakeSteps getBannerPhrasesFakeSteps() {
        return BaseSteps.getInstance(BannerPhrasesFakeSteps.class, secretJsonRPCConfig);
    }

    public CampaignFakeSteps getCampaignFakeSteps() {
        return BaseSteps.getInstance(CampaignFakeSteps.class, secretJsonRPCConfig);
    }

    public ClientFakeSteps getClientFakeSteps() {
        return BaseSteps.getInstance(ClientFakeSteps.class, secretJsonRPCConfig);
    }

    public EventLogFakeSteps getEventLogFakeSteps() {
        return BaseSteps.getInstance(EventLogFakeSteps.class, secretJsonRPCConfig);
    }

    public GroupsFakeSteps getGroupsFakeSteps() {
        return BaseSteps.getInstance(GroupsFakeSteps.class, secretJsonRPCConfig);
    }

    public StatisticsFakeSteps getStatisticsFakeSteps() {
        return BaseSteps.getInstance(StatisticsFakeSteps.class, secretJsonRPCConfig);
    }

    public GetBannersPhrasesSteps getBannersPhrasesSteps() {
        return BaseSteps.getInstance(GetBannersPhrasesSteps.class, httpConfig);
    }

    public RetargetingFakeSteps retargetingFakeSteps() {
        return BaseSteps.getInstance(RetargetingFakeSteps.class, secretJsonRPCConfig);
    }

    public YacoToolsSteps getYacoToolsSteps() {
        return BaseSteps.getInstance(YacoToolsSteps.class, jsonRPCConfig);
    }

    public CampaignsSumsForBsSteps getCampaignsSumsForBsSteps() {
        return BaseSteps.getInstance(CampaignsSumsForBsSteps.class, jsonRPCConfig);
    }

    public DirectConfigurationSteps getDirectConfigurationSteps() {
        return BaseSteps.getInstance(DirectConfigurationSteps.class, httpConfig);
    }

    public MailSmsFakeSteps getMailSmsFakeSteps() {
        return BaseSteps.getInstance(MailSmsFakeSteps.class, secretJsonRPCConfig);
    }

    public BannerSearchSteps getBannerSearchSteps() {
        return BaseSteps.getInstance(BannerSearchSteps.class, jsonRPCConfig);
    }

    public BannerLandSteps getBannerLandSteps() {
        return BaseSteps.getInstance(BannerLandSteps.class, jsonRPCConfig);
    }

    public ResyncCampaignsSteps getResyncCampaignsSteps() {
        return BaseSteps.getInstance(ResyncCampaignsSteps.class, jsonRPCConfig);
    }

    public AutobudgetSteps getAutobudgetSteps() {
        return BaseSteps.getInstance(AutobudgetSteps.class, jsonRPCConfig);
    }

    public CampaignInfoSteps getCampaignInfoSteps() {
        return BaseSteps.getInstance(CampaignInfoSteps.class, jsonRPCConfig);
    }

    public MirrorsSteps getMirrorsSteps() {
        return BaseSteps.getInstance(MirrorsSteps.class, jsonRPCConfig);
    }

    public RequestBlockNumberDetailedSteps getRequestBlockNumberDetailedSteps() {
        return BaseSteps.getInstance(RequestBlockNumberDetailedSteps.class, httpConfig);
    }

    public ClientDataSteps getClientDataSteps() {
        return BaseSteps.getInstance(ClientDataSteps.class, jsonRPCConfig);
    }

    public GetManagerInfoSteps getGetManagerInfoSteps() {
        return BaseSteps.getInstance(GetManagerInfoSteps.class, httpConfig);
    }

    public BmapiSteps getBmapiSteps() {
        return BaseSteps.getInstance(BmapiSteps.class, bmAPIConfig);
    }

    public AutobudgetOptimizedBySteps getAutobudgetOptimizedBySteps() {
        return BaseSteps.getInstance(AutobudgetOptimizedBySteps.class, jsonRPCConfig);
    }

    public BsFrontSteps getBsFrontSteps() {
        return BaseSteps.getInstance(BsFrontSteps.class, jsonRPCConfig);
    }

    public CurrencyRatesSteps getCurrencyRates() {
        return BaseSteps.getInstance(CurrencyRatesSteps.class, jsonRPCConfig);
    }

    public ExportRightsUidToCidSteps getExportRightsUidToCidSteps() {
        return BaseSteps.getInstance(ExportRightsUidToCidSteps.class, httpConfig);
    }

    public DjangoSearchNetAppContentSteps getDjangoSearchNetAppContentSteps() {
        return BaseSteps.getInstance(DjangoSearchNetAppContentSteps.class, httpConfig);
    }

    public BSExportPreprodParamsSteps getBsExportPreprodParamsSteps() {
        return BaseSteps.getInstance(BSExportPreprodParamsSteps.class, jsonRPCConfig);
    }

    public BalanceReviseSteps getBalanceReviseSteps() {
        return BaseSteps.getInstance(BalanceReviseSteps.class, jsonRPCConfig);
    }

    public TransportSteps getTransportSteps() {
        return BaseSteps.getInstance(TransportSteps.class, jsonRPCConfig)
                .withDBJooqSteps(getDirectJooqDbSteps())
                .withBsExportSteps(getBsExportSteps())
                .withRunScriptSteps(getRunScriptSteps());
    }

    public DirectEnvSteps directEnvSteps() {
        return BaseSteps.getInstance(DirectEnvSteps.class, jsonRPCConfig);
    }

    /**
     * Лучше место для этих степов не придумали. Передавать им конфиг нет смысла.
     */
    public YaDiskSteps getYaDiskSteps() {
        return new YaDiskSteps();
    }

    public CSRFSteps csrfSteps() {
        return BaseSteps.getInstance(CSRFSteps.class, jsonRPCConfig);
    }

    public DirectJooqDbSteps getDirectJooqDbSteps() {
        if (this.directJooqDbSteps == null) {
            this.directJooqDbSteps = new DirectJooqDbSteps();
        }
        return this.directJooqDbSteps;
    }

    public DirectJooqDbSteps getDirectJooqDbSteps(int shard) {
        return shardedDirectJooqDbSteps.computeIfAbsent(shard,
                s -> new DirectJooqDbSteps().useShard(s)
        );
    }

    public BlackboxSteps getBlackboxSteps() {
        return BaseSteps.getInstance(BlackboxSteps.class, blackboxConfig);
    }

    public SandboxServiceSteps getSandboxServiceSteps() {
        return BaseSteps.getInstance(SandboxServiceSteps.class, jsonRPCConfig);
    }

    public ClientsSteps getClientsSteps() {
        return BaseSteps.getInstance(ClientsSteps.class, httpConfig);
    }
}
