package ru.yandex.autotests.directapi.darkside.steps;


import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseHttpSteps;
import ru.yandex.autotests.directapi.dbconnection.DBInfo;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.HashMap;
import java.util.Map;

/**
 * Данные о конфигурации директа
 */
public class DirectConfigurationSteps extends BaseHttpSteps {
    private static final String DIRECT_CONFIGURATION_SERVICE_NAME = "DirectConfiguration";

    private static final String DB_INFO = "db_info";

    @Step("Вызов ручки DirectConfiguration")
    public Map getDirectConfiguration() {
        String response = executeMethodNoErrors(
                DIRECT_CONFIGURATION_SERVICE_NAME,
                new HashMap<>());
        return JsonUtils.getObject(response, Map.class);
    }

    public DBInfo getDBInfo() {
        Map map = getDirectConfiguration();
        if (map.containsKey(DB_INFO)) {
            return new DBInfo((Map) map.get(DB_INFO));
        }
        throw new DarkSideException("Не удалось найти db_info в DirectConfiguration");
    }

}
