package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.directenv.DirectEnvService;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.directenv.DirectPropertiesKeys;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.Map;

public class DirectEnvSteps extends BaseJsonRpcSteps<DirectEnvService> {

    @Step("jsonRpc=get_setting_name")
    public String getSettingsName() {
        return service().get_setting_name();
    }

    @Step("jsonRpc=get_settings получение значения из Settings.pm по названиям")
    public String getSettingsValue(DirectPropertiesKeys key) {
        return service().get_settings(key).get(key);
    }

    @Step("jsonRpc=get_settings получение значения из Settings.pm по названиям")
    public Map<DirectPropertiesKeys, String> getSettingsValues(DirectPropertiesKeys... keys) {
        return service().get_settings(keys);
    }

    @Override
    protected String getServiceName() {
        return DirectEnvService.SERVICE_NAME;
    }

    @Override
    protected Class<DirectEnvService> getClazz() {
        return DirectEnvService.class;
    }
}
