package ru.yandex.autotests.directapi.darkside.steps;

import com.google.gson.Gson;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import ru.yandex.autotests.direct.fakebsproxy.beans.updatestorecontent.UpdateStoreContentMobileResponseBean;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.CountryCurrencies;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseHttpSteps;
import ru.yandex.autotests.directapi.enums.ContentType;
import ru.yandex.autotests.directapi.enums.OSType;
import ru.yandex.qatools.allure.annotations.Step;

import java.io.IOException;
import java.net.URISyntaxException;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 16/11/15.
 */
public class DjangoSearchNetAppContentSteps extends BaseHttpSteps {
    public static final String BASE_HOST = "django.search.yandex.net";
    public static final int BASE_PORT = 8101;
    public static final String URL_PATH = "/process/app";
    public static final String APP_ID = "app_id";
    public static final String CONTENT_TYPE = "content_type";
    public static final String COUNTRY = "country";
    public static final String STORE = "store";

    @Step("Get test handles response")
    public UpdateStoreContentMobileResponseBean getTestHandleResponse(
            String appId
            , ContentType contentType
            , CountryCurrencies country
            , OSType osType){
        HttpGet get = new HttpGet();
        try {
            get.setURI(new URIBuilder().setScheme("http")
                    .setHost(BASE_HOST)
                    .setPort(BASE_PORT)
                    .setPath(URL_PATH)
                    .addParameter(APP_ID, appId)
                    .addParameter(CONTENT_TYPE, contentType.toString())
                    .addParameter(COUNTRY, country.requestDataCountry())
                    .addParameter(STORE, osType.getStore())
                    .build());
        } catch (URISyntaxException e) {
            throw new DarkSideException("Ошибка формировании запроса к ручке " + BASE_HOST + ": " + e.getMessage());
        }
        try {

            HttpResponse httpResponse = HttpClientBuilder.create().build().execute(get);
            assumeThat("получили хороший ответ от ручки", httpResponse.getStatusLine().getStatusCode(), equalTo(200));
            return new Gson().fromJson(EntityUtils.toString(httpResponse.getEntity())
                    , UpdateStoreContentMobileResponseBean.class);
        } catch (IOException e) {
            throw new DarkSideException("Ошибка при обращении к ручке " + get.getURI().toString()
                    + ": " + e.getMessage());
        }
    }
}
