package ru.yandex.autotests.directapi.darkside.steps;

import java.util.HashMap;
import java.util.List;

import one.util.streamex.StreamEx;

import ru.yandex.autotests.direct.utils.clients.tvm.ServiceTicketProviderProxy;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.directapi.darkside.clients.HttpClient;
import ru.yandex.autotests.directapi.darkside.connection.DarksideConfig;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.request.DostupAddRoleRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.request.DostupRemoveRoleRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.request.GetUserRolesRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.response.json.dostup.DostupAddRemoveRoleResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.response.json.dostup.DostupGetUserRolesResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.response.json.dostup.DostupInfoResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.response.json.dostup.RoleResponseData;
import ru.yandex.autotests.directapi.darkside.model.Role;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseHttpsSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static ch.lambdaj.Lambda.having;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Степы по работе с Управлятором
 * Раньше можно было работать только по токену, сейчас можно без него: DIRECT-28566
 * Токен привязывается к IP, поэтому для тестов в Акве его не нужно использовать
 */
public class DostupSteps extends BaseHttpsSteps {
    public static final String STAFF_LOGIN = "direct-roles-tester";

    /*
    Токен нужен для авторизации (сейчас на тестовых средах уже нет: DIRECT-28566)
    Получить можно так:
    perl -Iprotected -ME -MIntapi::DostupUserManagement -e 'p Intapi::DostupUserManagement::get_auth_token($ARGV[0])'
     77.88.4.162
    (подставить свой IP)
     */
//    private static final String TOKEN = "bTVpmlO64LuB42v2S_0W6Q";
    private static final String TOKEN = "5OcYGgOQvWr9G3yPjYfaaQ";

    private static final String ADD_ROLE = "idm/add-role";
    private static final String REMOVE_ROLE = "idm/remove-role";
    private static final String INFO = "idm/info";
    private static final String GET_USER_ROLES = "idm/get-user-roles";

    @Override
    public void init(DarksideConfig context) {
        super.init(context);

        long tvmDstClientId = DirectTestRunProperties.getInstance().getDirectIntapiTvmClientId();
        ServiceTicketProviderProxy serviceTicketsProvider = new ServiceTicketProviderProxy();

        setClient(new HttpClient(context, () -> serviceTicketsProvider.getServiceTicket(tvmDstClientId)));
    }

    @Step("Добавление роли с параметрами {0}")
    public void addRoleNoErrors(DostupAddRoleRequest request) {
        String responseText = executeUrlencodedPostMethodNoErrors(ADD_ROLE, request);
        DostupAddRemoveRoleResponse response = JsonUtils.getObject(responseText, DostupAddRemoveRoleResponse.class);
        assertThat("В ответе содержится ошибка",
                response,
                having(on(DostupAddRemoveRoleResponse.class).getCode(), equalTo(0)));
    }

    @Step("Добавление роли с параметрами {0} с ожиданием ошибки {1}")
    public void addRoleExpectError(DostupAddRoleRequest request, DostupAddRemoveRoleResponse error) {
        String responseText = executeUrlencodedPostMethodExpectReturnCode(ADD_ROLE, request, 200);
        DostupAddRemoveRoleResponse response = JsonUtils.getObject(responseText, DostupAddRemoveRoleResponse.class);
        assertThat("В ответе нет ожидаемой ошибки",
                response,
                beanEquals(error));
    }

    private DostupAddRemoveRoleResponse removeRole(DostupRemoveRoleRequest request) {
        String response = executeUrlencodedPostMethodNoErrors(REMOVE_ROLE, request);
        return JsonUtils.getObject(response, DostupAddRemoveRoleResponse.class);
    }

    @Step("Удаление роли с параметрами {0}")
    public void removeRoleNoErrors(DostupRemoveRoleRequest request) {
        DostupAddRemoveRoleResponse response = removeRole(request);
        assertThat("В ответе содержится ошибка",
                response,
                having(on(DostupAddRemoveRoleResponse.class).getCode(), equalTo(0)));
    }

    @Step("Удаление роли с параметрами {0} с ожиданием ошибки {1}")
    public void removeRoleExpectError(DostupRemoveRoleRequest request, DostupAddRemoveRoleResponse error) {
        String responseText = executeUrlencodedPostMethodExpectReturnCode(REMOVE_ROLE, request, 200);
        DostupAddRemoveRoleResponse response = JsonUtils.getObject(responseText, DostupAddRemoveRoleResponse.class);
        assertThat("В ответе нет ожидаемой ошибки",
                response,
                beanEquals(error));
    }

    @Step("Получение списка ролей для логина {0}")
    public DostupGetUserRolesResponse getUserRolesNoErrors(String login) {
        String response = executeMethodNoErrors(
                GET_USER_ROLES,
                new GetUserRolesRequest()
                        .withLogin(login)
        );
        DostupGetUserRolesResponse dostupGetUserRolesResponse =
                JsonUtils.getObject(response, DostupGetUserRolesResponse.class);
        assertThat("В ответе ошибка",
                dostupGetUserRolesResponse.getCode(),
                equalTo(0));
        return dostupGetUserRolesResponse;
    }

    @Step("Вызов idm/info")
    public DostupInfoResponse infoNoErrors() {
        String response = executeMethodNoErrors(
                INFO,
                new HashMap<>()
        );
        DostupInfoResponse dostupInfoResponse =
                JsonUtils.getObject(response, DostupInfoResponse.class);
        assertThat("В ответе ошибка",
                dostupInfoResponse.getCode(),
                equalTo(0));
        return dostupInfoResponse;
    }


    @Step("Удаление всех ролей, которые есть у пользователя {0}")
    public void clearRoles(String staffLogin) {
        DostupGetUserRolesResponse response =
                getUserRolesNoErrors(staffLogin);
        // роль manager должна удаляться после ролей teamleader, superteamleader
        List<RoleResponseData> roles = StreamEx.of(response.getRoles())
                .sortedBy(r -> Role.MANAGER.getRoleName().equals(r.getRoleName()) ? 1 : 0)
                .toList();
        for (RoleResponseData role : roles) {
            removeRole(
                    new DostupRemoveRoleRequest()
                            .withLogin(staffLogin)
                            .withRole(role.getRoleName())
                            .withPassportLogin(role.getPassportLogin())
            );
        }
    }
}
