package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.steps.base.BaseHttpSteps;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class FileStorageSteps extends BaseHttpSteps {

    static final String ACTION = "action";
    static final String CONTENT = "content";
    static final String OWNER = "owner";
    static final String CLIENT_ID = "ClientID";
    static final String TYPE = "type";
    static final String ID = "id";

    static final String PUT_FILE = "put_file";
    static final String GET_FILE = "get_file";
    static final String REMOVE_FILE = "remove_file";

    static final String FILE_STORAGE = "file-storage";

    /**
     * Сохранение файла на сервере
     *
     * @param content содержимое файла
     * @param owner   ID владельца файла (не проверяется на корректность)
     * @param type    используется в качестве аналога директории
     * @return возвращает ID созданного файла
     */
    public String putFile(String content, String owner, String clientId, String type) {
        Map<String, String> params = new HashMap<>();
        params.put(ACTION, PUT_FILE);
        params.put(CONTENT, content);
        params.put(OWNER, owner);
        params.put(CLIENT_ID, clientId);
        params.put(TYPE, type);
        URI uri = client().buildURIFromParams(FILE_STORAGE, params);
        return client().sendPostRequest(uri).getMessage();
    }

    public String putDefaultFile(Long clientId, Long uid) {
        return putFile("test", String.valueOf(uid), String.valueOf(clientId), "documents");
    }

    /**
     * Получение содержимого файла
     *
     * @param id   ID файла
     * @param type используется в качестве аналога директории
     * @return возвращает содержимое файла
     */
    public String getFile(String id, String type) {
        Map<String, String> params = new HashMap<>();
        params.put(ACTION, GET_FILE);
        params.put(ID, id);
        params.put(TYPE, type);
        URI uri = client().buildURIFromParams(FILE_STORAGE, params);
        return client().sendPostRequest(uri).getMessage();
    }

    /**
     * Удаление файла
     *
     * @param id   ID файла
     * @param type используется в качестве аналога директории
     * @return возвращает пустую строку в случае успеха
     */
    public String removeFile(String id, String type) {
        Map<String, String> params = new HashMap<>();
        params.put(ACTION, REMOVE_FILE);
        params.put(ID, id);
        params.put(TYPE, type);
        URI uri = client().buildURIFromParams(FILE_STORAGE, params);
        return client().sendPostRequest(uri).getMessage();
    }
}
