package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.http.request.GetManagerInfoRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.response.json.GetManagerInfoResponse;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseHttpSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Стэпы для работы с методом геоконтекста
 *  https://st.yandex-team.ru/TESTIRT-6105
 */
public class GetManagerInfoSteps extends BaseHttpSteps {

    private static final String GET_MANAGER_INFO = "intapi/get_manager_info";

    @Step("Получение списка ролей для логина {0}")
    public GetManagerInfoResponse getManagerInfoNoErrors(String uid) {
        String response = executeMethodNoErrors(
                GET_MANAGER_INFO,
                new GetManagerInfoRequest()
                        .withUid(uid)
        );
        GetManagerInfoResponse getManagerInfoResponse =
                JsonUtils.getObject(response, GetManagerInfoResponse.class);
        assertThat("В ответе ошибка",
                getManagerInfoResponse.getError(),
                nullValue());
        return getManagerInfoResponse;
    }

}
