package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.http.request.AgencyCheckForMetricaRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.request.CampaignsForMetricaRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.request.RetargetingForMetricaRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.response.json.AgencyCheckForMetrikaResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.response.tsv.RetargetingSegmentsForMetricaResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.response.yaml.CampaignsForMetricaResponse;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseHttpSteps;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * Вызовы методов старого транспорта с Метрикой
 */
public class MetricaOldTransportSteps extends BaseHttpSteps {

    //region method names
    private static final String CAMPAIGNS_FOR_METRICA = "campaignsformetrica";
    private static final String EXPORT_CAMPAIGNS_FOR_METRICA = "ExportCampaignsForMetrica";
    private static final String RETARGETING_SEGMENTS_FOR_METRICA = "RetargetingSegmentsForMetrika";
    private static final String CHECK_AGENCY_RIGHTS_FOR_METRICA = "CheckAgencyRightsForMetrika";
    //endregion

    //region uids for AgencyCheckForMetrica
    public static final String AGENCY_UID = "50436888"; //(at-direct-ag-full) - агентство
    public static final String FULL_AGENT_UID = "109510135";
    //(at-direct-ag-unlimit-rep) - полноправный представитель at-direct-ag-full
    public static final String LIMITED_AGENT_UID = "109510421";
    //(at-direct-ag-limit-rep) - ограниченный представитель at-direct-ag-full
    public static final String AGENCY_CLIENT_UID = "245813548"; //(account-subclient-shard2) - клиент at-direct-ag-full
    public static final String LIMITED_AGENT_CLIENT_UID = "24776426"; //(testTT) - клиент at-direct-ag-limit-rep
    public static final String NON_AGENCY_CLIENT_UID = "225571559";
    //(andy-ilyin-client) - клиент, не привязанный ни к какому агентству
    public static final String ANOTHER_AGENCY_UID = "228337394"; //at-direct-ag-new-c
    //endregion

    //region campaignsformetrica
    /**
     * версия без tvm
     *
     * @deprecated используй {@link #exportCampaignsForMetricaNoErrors}
     */
    @Deprecated
    @Step("Вызов CampaignsForMetrica для uid = {0}")
    public CampaignsForMetricaResponse campaignsForMetricaNoErrors(int uid) {
        String response = executeMethodNoErrors(
                CAMPAIGNS_FOR_METRICA,
                new CampaignsForMetricaRequest()
                        .withUid(uid)
        );
        return new CampaignsForMetricaResponse(response);
    }

    /**
     * версия без tvm
     *
     * @deprecated используй {@link #exportCampaignsForMetricaExpectError}
     */
    @Deprecated
    @Step("Вызов CampaignsForMetrica для uid = {0} с ожиданием ошибки {1}")
    public void campaignsForMetricaExpectError(String uid, int errorCode) {
        executeMethodExpectReturnCode(
                CAMPAIGNS_FOR_METRICA,
                new CampaignsForMetricaRequest()
                        .withUid(uid),
                errorCode
        );
    }

    /**
     * версия без tvm
     *
     * @deprecated используй {@link #exportCampaignsForMetricaNoErrors}
     */
    @Deprecated
    @Step("Вызов CampaignsForMetrica для uid = {0}, выдача баннеров без домена = {1}")
    public CampaignsForMetricaResponse campaignsForMetricaNoErrors(int uid, boolean emptyDomainIsOk) {
        String response = executeMethodNoErrors(
                CAMPAIGNS_FOR_METRICA,
                new CampaignsForMetricaRequest()
                        .withUid(uid)
                        .withEmptyDomainIsOk(emptyDomainIsOk)
        );
        return new CampaignsForMetricaResponse(response);
    }
    //endregion

    //region exportcampaignsformetrica
    @Step("Вызов ExportCampaignsForMetrica для uid = {0}")
    public CampaignsForMetricaResponse exportCampaignsForMetricaNoErrors(int uid) {
        String response = executeMethodNoErrors(
                EXPORT_CAMPAIGNS_FOR_METRICA,
                new CampaignsForMetricaRequest()
                        .withUid(uid)
        );
        return new CampaignsForMetricaResponse(response);
    }

    @Step("Вызов ExportCampaignsForMetrica для uid = {0} с ожиданием ошибки {1}")
    public void exportCampaignsForMetricaExpectError(String uid, int errorCode) {
        executeMethodExpectReturnCode(
                EXPORT_CAMPAIGNS_FOR_METRICA,
                new CampaignsForMetricaRequest()
                        .withUid(uid),
                errorCode
        );
    }

    @Step("Вызов ExportCampaignsForMetrica для uid = {0}, выдача баннеров без домена = {1}")
    public CampaignsForMetricaResponse exportCampaignsForMetricaNoErrors(int uid, boolean emptyDomainIsOk) {
        String response = executeMethodNoErrors(
                EXPORT_CAMPAIGNS_FOR_METRICA,
                new CampaignsForMetricaRequest()
                        .withUid(uid)
                        .withEmptyDomainIsOk(emptyDomainIsOk)
        );
        return new CampaignsForMetricaResponse(response);
    }
    //endregion

    //region retargetingSegmentsForMetrica
    @Step("Вызов RetargetingSegmentsForMetrica")
    public RetargetingSegmentsForMetricaResponse retargetingSegmentsForMetricaNoErrors(
            RetargetingForMetricaRequest request)
    {
        String responceText = executeMethodNoErrors(RETARGETING_SEGMENTS_FOR_METRICA, request);
        return new RetargetingSegmentsForMetricaResponse(responceText);
    }

    @Step("Вызов RetargetingSegmentsForMetrica с ожиданием ошибки {1}")
    public void retargetingSegmentsForMetricaExpectError(
            RetargetingForMetricaRequest request, int errorCode)
    {
        executeMethodExpectReturnCode(
                RETARGETING_SEGMENTS_FOR_METRICA,
                request,
                errorCode
        );
    }
    //endregion

    //region checkagencyrightsformetrika
    @Step("Вызов CheckAgencyRightsForMetrika для uid = {0}, agency_uid = {1}, client_uid = {2}")
    public AgencyCheckForMetrikaResponse checkAgencyRightsForMetrikaNoErrors(
            String uid, String agencyUid, String clientUid)
    {
        String responseText = executeMethodNoErrors(
                CHECK_AGENCY_RIGHTS_FOR_METRICA,
                new AgencyCheckForMetricaRequest()
                        .withUid(uid)
                        .withAgencyUid(agencyUid)
                        .withClientUid(clientUid)
        );
        return new AgencyCheckForMetrikaResponse(responseText);
    }

    @Step("Вызов CheckAgencyRightsForMetrika для uid = {0}, agency_uid = {1}, client_uid = {2} с ожиданием ошибки {3}")
    public void checkAgencyRightsForMetrikaExpectError(
            String uid, String agencyUid, String clientUid, int errorCode)
    {
        executeMethodExpectReturnCode(
                CHECK_AGENCY_RIGHTS_FOR_METRICA,
                new AgencyCheckForMetricaRequest()
                        .withUid(uid)
                        .withAgencyUid(agencyUid)
                        .withClientUid(clientUid),
                errorCode
        );
    }
    //endregion
}
