package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.MirrorsService;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

public class MirrorsSteps extends BaseJsonRpcSteps<MirrorsService> {

    @Step("Вызов Mirrors.get_domain_filter_for_bs")
    public String[] getDomainFilterForBs(String... domains) {
        return service().get_domain_filter_for_bs(domains);
    }

    @Override
    protected MirrorsService initService() {
        return client().getServiceWithOneComplexParam(getServiceName(), getClazz());
    }

    @Override
    protected String getServiceName() {
        return MirrorsService.SERVICE_NAME;
    }

    @Override
    protected Class<MirrorsService> getClazz() {
        return MirrorsService.class;
    }
}
