package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.http.request.RequestBlockNumberDetailedRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.http.response.json.RequestBlockNumberDetailedResponse;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseHttpSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

public class RequestBlockNumberDetailedSteps extends BaseHttpSteps {
    private static final String REQUEST_BLOCK_NUMBER_DETAILED = "RequestBlockNumberDetailed";

    @Step("Получение кол-ва групп, объявлений, фраз разных статусов принадлежащих кампании с campaignCode = {0}.")
    public RequestBlockNumberDetailedResponse getRequestBlockNumberDetailed(Long campaignCode) {
        String response = executeMethodNoErrors(
                REQUEST_BLOCK_NUMBER_DETAILED,
                new RequestBlockNumberDetailedRequest()
                        .withCampaignCode(campaignCode)
                );
        return JsonUtils.getObject(response, RequestBlockNumberDetailedResponse.class);
    }

    @Step("Попытка получить кол-во групп, объявлений, фраз разных статусов принадлежащих кампании с невалидным campaignCode = {0}.")
    public void getRequestBlockNumberDetailedWithError(Long campaignCode, String errorText) {
        executeMethodExpectError(
                REQUEST_BLOCK_NUMBER_DETAILED,
                new RequestBlockNumberDetailedRequest()
                        .withCampaignCode(campaignCode),
                errorText
        );
    }
}
