package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.ResyncCampaignsResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.ResyncCampaignsService;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class ResyncCampaignsSteps extends BaseJsonRpcSteps<ResyncCampaignsService> {

    @Step("Вызов ResyncCampaigns.add")
    public void add(Long... cids) {
        ResyncCampaignsResponse response = service().add(cids);
        assertThat("Метод ResyncCampaigns.add завершился успешно", response.getSuccess(), equalTo(1));
    }

    @Override
    protected ResyncCampaignsService initService() {
        return client().getServiceWithOneComplexParam(getServiceName(), getClazz());
    }

    @Override
    protected String getServiceName() {
        return ResyncCampaignsService.SERVICE_NAME;
    }

    @Override
    protected Class<ResyncCampaignsService> getClazz() {
        return ResyncCampaignsService.class;
    }
}
