package ru.yandex.autotests.directapi.darkside.steps;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.autotests.direct.scriptrunner.service.clientdata.ClientDataParams;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;

/**
 * Created by pashkus on 19.10.16.
 */

public class ScriptParamsProfiles {

    private Map<String, ClientDataParams> clientDataParamsMap = new HashMap<>();

    public ScriptParamsProfiles(DirectTestRunProperties properties) {
        initDefaultClientDataParamsProfile(properties);
        addProfile(ProfileNames.FULL_EXPORT.toString(),
                getDefaultProfileClone()
                        .withParId("full_lb_export:1")
                        .withFakeBs(false)
                        .withNoLogbroker(false));
        addProfile(ProfileNames.CAMPS_ONLY.toString(),
                getDefaultProfileClone().withParId("camps_only:1"));
        addProfile(ProfileNames.INTERNAL_ADS.toString(),
                getDefaultProfileClone().withParId("internal_ads:1"));
        addProfile(ProfileNames.AS_SOON_AS_POSSIBLE.toString(),
                getDefaultProfileClone().withParId("fast:1"));
    }

    /**
     * Basic set of parameters for bsClientData. Used in most part of tests
     *
     * @param properties
     */
    private void initDefaultClientDataParamsProfile(DirectTestRunProperties properties) {
        ClientDataParams defaultClientDataParams = new ClientDataParams()
                .withOnce(true)
                .withParId("std:1")
                .withFakeBs(properties.isDirectTransportFakeBS())
                .withNoSend(!properties.isDirectTransportBkSendToBS())
                .withNoAutoBuggy(properties.isDirectTransportNoAutoBuggy())
                .withNoLogbroker(properties.isDirectTransportNoLogbroker())
                .withFakeBSUrlData(properties.getDirectTransportBSUrlData())
                .withFakeBSUrlPrices(properties.getDirectTransportBSUrlData());
        clientDataParamsMap.put(ProfileNames.DEFAULT.toString(), defaultClientDataParams);
    }

    public ClientDataParams getProfileClone(String profileName) {
        return clientDataParamsMap.get(profileName);
    }

    public ClientDataParams getDefaultProfileClone() {
        return new ClientDataParams(clientDataParamsMap.get(ProfileNames.DEFAULT.toString()));
    }

    public void addProfile(String profileName, ClientDataParams clientDataParams) {
        clientDataParamsMap.put(profileName, clientDataParams);
    }

    public enum ProfileNames {
        DEFAULT("default"),
        FULL_EXPORT("full_export"),
        CAMPS_ONLY("camps_only"),
        INTERNAL_ADS("internal_ads"),
        AS_SOON_AS_POSSIBLE("as_soon_as_possible");

        String profileName;

        ProfileNames(String profileName) {
            this.profileName = profileName;
        }

        public String toString() {
            return this.profileName;
        }
    }
}
