package ru.yandex.autotests.directapi.darkside.steps;

import java.util.Map;

import org.hamcrest.Matcher;

import ru.yandex.autotests.directapi.darkside.datacontainers.soap.EmptyResponseData;
import ru.yandex.autotests.directapi.darkside.datacontainers.soap.HashRequestData;
import ru.yandex.autotests.directapi.darkside.datacontainers.soap.SetBannerAutobudgetShowStatusRequestData;
import ru.yandex.autotests.directapi.darkside.datacontainers.soap.SetBannerAutobudgetStatusRequest;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseSoapSteps;
import ru.yandex.qatools.allure.annotations.Step;

public class SoapClientSteps extends BaseSoapSteps {
    public static final String SET_AUTOBUDGET_SHOW_STATUS = "setAutobudgetShowStatus";
    public static final String SET_CAMP_DAY_BUDGET_LIMIT_STOP_TIME = "setCampDayBudgetLimitStopTime";

    @Step("Вызов метода {0}")
    public void checkSetBannerAutobudgetShowStatusNoErrors(
            String methodName,
            SetBannerAutobudgetShowStatusRequestData requestData) {
        SetBannerAutobudgetStatusRequest request = new SetBannerAutobudgetStatusRequest(requestData);
        executeMethodNoErrors(
                methodName,
                request,
                new EmptyResponseData()
        );
    }

    @Step("Вызов метода {0} c ожиданием ошибки: {2}")
    public void setBannerAutobudgetShowStatusExpectedError(
            String methodName,
            SetBannerAutobudgetShowStatusRequestData requestData,
            Matcher<String> matcher) {
        SetBannerAutobudgetStatusRequest request = new SetBannerAutobudgetStatusRequest(requestData);
        executeMethodExpectError(
                methodName,
                request,
                matcher
        );
    }

    @Step("Вызов метода {method}")
    public void setCampDayBudgetLimitStopTime(Map<Integer, String> data) {
        HashRequestData request = new HashRequestData(data);
        executeMethodNoErrors(
                SET_CAMP_DAY_BUDGET_LIMIT_STOP_TIME,
                request,
                new EmptyResponseData()
        );
    }

    @Step("Вызов метода setCampDayBudgetLimit c ожиданием ошибки: {1}")
    public void setCampDayBudgetLimitStopTimeExpectedError(Map<Integer, String> data, Matcher<String> matcher) {
        HashRequestData request = new HashRequestData(data);
        executeMethodExpectError(
                SET_CAMP_DAY_BUDGET_LIMIT_STOP_TIME,
                request,
                matcher
        );
    }
}
