package ru.yandex.autotests.directapi.darkside.steps;

import org.apache.commons.io.FileUtils;
import ru.yandex.autotests.qa.disk.Disk;
import ru.yandex.qatools.allure.annotations.Step;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class YaDiskSteps {

    @Step("Загрузка файла из Яндекс.Диска: {0}")
    public InputStream get(String path) {
        return Disk.get(path);
    }

    @Step("Загрузка файла из Яндекс.Диска во временный файл {0}")
    public File getToTempFile(String path) {
        File tempFile = createTempFile();
        InputStream is = Disk.get(path);
        copyInputStreamToFile(is, tempFile);
        return tempFile;
    }

    private File createTempFile() {
        try {
            return File.createTempFile("ya-disk", "tmp");
        } catch (IOException e) {
            throw new IllegalStateException("ошибка создания временного файла для загрузки из Яндекс.Диска");
        }
    }

    private void copyInputStreamToFile(InputStream source, File f) {
        try {
            FileUtils.copyInputStreamToFile(source, f);
        } catch (IOException e) {
            throw new IllegalStateException("ошибка копирования во временный файл файла из Яндекс.Диска");
        }
    }
}
