package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.yacotools.SetCategoriesData;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.yacotools.YacoToolsService;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.yacotools.YacobotResponse;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class YacoToolsSteps extends BaseJsonRpcSteps<YacoToolsService> {

    @Step("Вызов setCategories с параметрами {0}")
    public void setCategories(SetCategoriesData setCategoriesData) {
        YacobotResponse response = service().setCategories(setCategoriesData.getData());
        YacobotResponse goodResponse = new YacobotResponse(0, "");
        assertThat("Ожидался успешный вызов метода", response, beanEquals(goodResponse));
    }

    @Override
    protected YacoToolsService initService() {
        return client().getServiceWithOneComplexParam(getServiceName(), getClazz());
    }

    @Override
    protected String getServiceName() {
        return YacoToolsService.SERVICE_NAME;
    }

    @Override
    protected Class<YacoToolsService> getClazz() {
        return YacoToolsService.class;
    }
}
