package ru.yandex.autotests.directapi.darkside.steps.base;


import ru.yandex.autotests.directapi.darkside.clients.IntapiJsonRpcClient;
import ru.yandex.autotests.directapi.darkside.connection.DarksideConfig;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;

/**
 * Базовый класс для степов методов, работающих по json-rpc
 */
public abstract class BaseJsonRpcSteps<T> extends BaseIntApiSteps<IntapiJsonRpcClient> {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private T service;

    @Override
    public void init(DarksideConfig context) {
        super.init(context);
        setClient(new IntapiJsonRpcClient(context));
        service = initService();
    }

    protected T service() {
        return service;
    }

    protected LogSteps log() {
        return log;
    }

    protected T initService() {
        return client().getServiceWithNamedParams(getServiceName(), getClazz());
    }

    protected abstract String getServiceName();
    protected abstract Class<T> getClazz();
}
