package ru.yandex.autotests.directapi.darkside.steps.base;

import org.hamcrest.Matcher;
import ru.yandex.autotests.directapi.darkside.clients.IntapiSoapClient;
import ru.yandex.autotests.directapi.darkside.connection.DarksideConfig;
import ru.yandex.autotests.directapi.darkside.datacontainers.soap.BaseSoapRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.soap.BaseSoapResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.soap.ErrorResponseData;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by omaz on 26.03.14.
 * Базовый класс для степов методов, работающих по soap
 */
public abstract class BaseSoapSteps extends BaseIntApiSteps<IntapiSoapClient> {

    @Override
    public void init(DarksideConfig context) {
        super.init(context);
        setClient(new IntapiSoapClient(context));
    }

    public void executeMethod(String methodName, BaseSoapRequest params, BaseSoapResponse response) {
        params.setMethodName(methodName);
        client().sendRequest(params, response);
    }

    public void executeMethodExpectError(String methodName, BaseSoapRequest params, BaseSoapResponse response,
                                         BaseSoapResponse expectedResponse) {
        executeMethod(methodName, params, response);
        /*assertThat("Ответ не совпадает с ожидаемым", response, beanDiffer(expectedResponse));*/
        assertThat("Ответ не совпадает с ожидаемым",        //TODO-b think again
                JsonUtils.toString(response.getResponseObject()),
                equalTo(JsonUtils.toString(expectedResponse.getResponseObject())));
    }

    public void executeMethodExpectError(String methodName, BaseSoapRequest params, Matcher<String> matcher) {
        ErrorResponseData responseData = new ErrorResponseData();
        executeMethod(methodName, params, responseData);
        assertThat("Не совпадает текст ошибки", responseData.getMessage(), matcher);
    }

    public void executeMethodNoErrors(String methodName, BaseSoapRequest params, BaseSoapResponse response) {

        executeMethod(methodName, params, response);
    }
}
