package ru.yandex.autotests.directapi.darkside.steps.fakesteps;

import java.util.List;
import java.util.concurrent.Callable;

import org.apache.commons.collections.CollectionUtils;
import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.beans.BeanPropertyPredicate;
import ru.yandex.autotests.directapi.darkside.BannerSystemUtils;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerPhraseFakeInfo;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.qatools.allure.annotations.Step;

import static ch.lambdaj.Lambda.forEach;
import static java.util.Arrays.asList;
import static org.hamcrest.CoreMatchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class BannerPhrasesFakeSteps extends BaseFakeSteps {

    @Step("[FakePhrasesParams]: получение списка фраз группы pid = {0}")
    public BannerPhraseFakeInfo[] getBannerPhrasesParams(Long pid) {
        return service().FakeGetPhrasesParams(String.valueOf(pid));
    }

    @Step("[FakePhrasesParams]: получение фразы bids.id = {0}")
    public BannerPhraseFakeInfo getBannerPhraseParams(long bidsId) {
        BannerPhraseFakeInfo[] phraseInfos = service().FakeGetPhrasesParams(bidsId);
        if (phraseInfos.length > 1) {
            throw new DarkSideException("Найдено более одной фразы по bids.id == " + bidsId);
        }
        return phraseInfos.length > 0 ? phraseInfos[0] : null;
    }

    @Step("[FakeGetPhrasesParams]: получить параметры фразы bidsId = {0}")
    public BannerPhraseFakeInfo[] getPhrasesParamsById(long bidsId) {
        return service().FakeGetPhrasesParams(bidsId);
    }

    @Step("[FakeGetPhrasesParams]: получить список id всех фраз, принадлежащих группе pid = {0}")
    public long[] getPhraseIdsByPid(Long pid) {
        BannerPhraseFakeInfo[] phrasesFakeInfo = getBannerPhrasesParams(pid);
        long[] phraseIds = new long[phrasesFakeInfo.length];
        for (int i = 0; i < phrasesFakeInfo.length; i++) {
            phraseIds[i] = phrasesFakeInfo[i].getId();
        }
        return phraseIds;
    }

    @Step("[FakeGetPhrasesParams]: установить для фразы id = {0} статус модерации statusModerate = {1}")
    public void setStatusModerate(long bidsId, String status) {
        BannerPhraseFakeInfo phraseInfo = getBannerPhraseParams(bidsId);
        phraseInfo.setStatusModerate(status);
        updateBannerPhrasesParams(new BannerPhraseFakeInfo[]{phraseInfo});
    }
    @Step
    public void makeKeywordModerated(long bidsId) {
        setStatusModerate(bidsId, Status.YES);
    }

    public void makePhraseActive(long bidsId) {
        setPhraseStatuses(bidsId, Status.YES, Status.YES);
    }

    public void setPhraseStatuses(long bidsId, String statusModerate, String statusBsSynced) {
        BannerPhraseFakeInfo info = getBannerPhraseParams(bidsId);
        info.setStatusModerate(statusModerate);
        info.setStatusBsSynced(statusBsSynced);
        updateBannerPhrasesParams(new BannerPhraseFakeInfo[]{info});
    }

    @Step("[FakeGetPhrasesParams]: установить для фразы id = {0} статус statusBsSynced = {1}")
    public void setStatusBsSynced(long bidsId, String status) {
        BannerPhraseFakeInfo phraseInfo = getBannerPhraseParams(bidsId);
        phraseInfo.setStatusBsSynced(status);
        updateBannerPhrasesParams(new BannerPhraseFakeInfo[]{phraseInfo});
    }

    /*
        deprecation reasons:
            1. default method "getBannerPhraseParams" must search by primary key
            2. unexpected asserts
        use method getBannerPhraseParams(long bidsId)
     */
    @Deprecated
    @Step("GetBannerPhraseParams bannerID = {0}, phraseID = {1}")
    public BannerPhraseFakeInfo getBannerPhraseParams(Long bannerID, Long phraseID) {
        BannerFakeInfo bannerFakeInfo = service().FakeGetBannerParams(bannerID);
        assertThat("Нет данных по баннеру " + bannerID, bannerFakeInfo, notNullValue());
        assertThat("Отсутствует pid для баннера", bannerFakeInfo.getPid(), notNullValue());
        BannerPhraseFakeInfo[] phrases = getPhrasesParamsById(phraseID);
        BannerPhraseFakeInfo phrase = (BannerPhraseFakeInfo) CollectionUtils
                .find(asList(phrases), new BeanPropertyPredicate("pid", bannerFakeInfo.getPid()));
        return phrase;
    }

    public void updateBannerPhrasesParams(List<BannerPhraseFakeInfo> bannerPhraseFakeInfos) {
        updateBannerPhrasesParams(bannerPhraseFakeInfos.toArray(new BannerPhraseFakeInfo[0]));
    }

    @Step("[FakePhrasesParams]: updateBannerPhrasesParams")
    public void updateBannerPhrasesParams(BannerPhraseFakeInfo[] bannerPhraseFakeInfos) {
        updateService().FakePhrasesParams(bannerPhraseFakeInfos);
    }

    @Step("[FakePhrasesParams]: установить statusModerate = Yes всем фразам в группе pid = {0}")
    public void setPhraseStatusModerateYes(Long adGroupID) {
        List<BannerPhraseFakeInfo> bannerPhraseFakeInfoList = asList(getBannerPhrasesParams(adGroupID));
        if (!bannerPhraseFakeInfoList.isEmpty()) {
            forEach(bannerPhraseFakeInfoList).setStatusModerate(Status.YES);
            updateBannerPhrasesParams(bannerPhraseFakeInfoList);
        }
    }

    public void setPhraseStatusBsSyncedYes(Long adGroupID) {
        List<BannerPhraseFakeInfo> bannerPhraseFakeInfoList = asList(getBannerPhrasesParams(adGroupID));
        if (!bannerPhraseFakeInfoList.isEmpty()) {
            forEach(bannerPhraseFakeInfoList).setStatusBsSynced(Status.YES);
            updateBannerPhrasesParams(bannerPhraseFakeInfoList);
        }
    }

    public void setBannerFakePhraseIds(Long adGroupID) {
        List<BannerPhraseFakeInfo> bannerPhraseFakeInfoList = asList(getBannerPhrasesParams(adGroupID));
        for (BannerPhraseFakeInfo bannerPhraseFakeInfo : bannerPhraseFakeInfoList) {
            bannerPhraseFakeInfo.setPhraseID(BannerSystemUtils.getBsPhraseId(bannerPhraseFakeInfo.getPhrase()));
        }
        updateBannerPhrasesParams(bannerPhraseFakeInfoList);
    }

    @Deprecated
    public void phraseShouldHaveText(Long bannerID, long phraseID, Matcher matcher) {
        BannerPhraseFakeInfo resultPhrase = getBannerPhraseParams(bannerID, phraseID);
        assertThat("Текст фразы не соответствует ожидаемому", resultPhrase.getPhrase(), matcher);
    }

    public void phraseShouldHaveText(long bidsId, Matcher matcher) {
        BannerPhraseFakeInfo resultPhrase = getBannerPhraseParams(bidsId);
        assertThat("Текст фразы не соответствует ожидаемому", resultPhrase.getPhrase(), matcher);
    }

    @Deprecated
    public void phraseShouldHaveOptimizeTry(Long bannerID, long phraseID, Matcher matcher) {
        BannerPhraseFakeInfo resultPhrase = getBannerPhraseParams(bannerID, phraseID);
        assertThat("Значение optimizeTry не соответствует ожидаемому", resultPhrase.getOptimizeTry(), matcher);
    }

    public void phraseShouldHaveOptimizeTry(long bidsId, Matcher matcher) {
        BannerPhraseFakeInfo resultPhrase = getBannerPhraseParams(bidsId);
        assertThat("Значение optimizeTry не соответствует ожидаемому", resultPhrase.getOptimizeTry(), matcher);
    }

    public Callable<Boolean> statusBsSyncedIs(long phraseID, String statusBsSynced) {
        return () -> getBannerPhraseParams(phraseID).getStatusBsSynced().equals(statusBsSynced);
    }
}
