package ru.yandex.autotests.directapi.darkside.steps.fakesteps;

import ru.yandex.autotests.directapi.darkside.clients.IntapiJsonRpcClient;
import ru.yandex.autotests.directapi.darkside.connection.DarksideConfig;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.FakeAdminService;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.FakeAdminUpdateService;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseIntApiSteps;

public abstract class BaseFakeSteps extends BaseIntApiSteps<IntapiJsonRpcClient> {
    private FakeAdminService service;
    private FakeAdminUpdateService updateService;
    private FakeAdminUpdateService updateServiceWithNullFields;

    @Override
    public void init(DarksideConfig context) {
        super.init(context);
        IntapiJsonRpcClient client = new IntapiJsonRpcClient(context);
        service =
                client.getServiceWithNamedParams(
                        FakeAdminService.SERVICE_NAME, FakeAdminService.class);

        //Update ignore null fields (Default choice)
        updateService =
                client.getServiceWithOneComplexParam(
                        FakeAdminService.SERVICE_NAME, FakeAdminUpdateService.class, true);

        //Update with null fields
        updateServiceWithNullFields =
                client.getServiceWithOneComplexParam(
                        FakeAdminService.SERVICE_NAME, FakeAdminUpdateService.class, false);
    }

    protected FakeAdminService service() {
        return service;
    }

    protected FakeAdminUpdateService updateService() {
        return updateService;
    }

    protected FakeAdminUpdateService updateServiceWithNullFields() {
        return updateServiceWithNullFields;
    }
}
