package ru.yandex.autotests.directapi.darkside.steps.fakesteps;

import com.hazelcast.core.HazelcastInstance;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.ClientFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.ConvertCurrencyClientFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.SetDiscountInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.VATRateInfo;
import ru.yandex.autotests.directapi.darkside.model.APIEnabled;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.HazelcastClient;
import ru.yandex.qatools.hazelcast.HazelcastProperties;

import java.util.HashMap;
import java.util.concurrent.locks.Lock;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.number.OrderingComparison.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://jira.yandex-team.ru/browse/DIRECT-18962
 */
public class ClientFakeSteps extends BaseFakeSteps {
    private static HazelcastInstance hz;

    @Step("[FakeClientParams]: updateClientParams")
    public void updateClientParams(ClientFakeInfo clientParams) {
        updateService().FakeClientParams(clientParams);
    }

    //region API enabled flag
    @Step("Установка флага APIEnabled: login = {0}, value = {1}")
    public void setAPIEnabled(String login, String value) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setAPIEnabled(value);
        updateClientParams(client);
    }

    @Step("Включить доступ к API: login = {0}")
    public void enableAPI(String login) {
        setAPIEnabled(login, APIEnabled.YES);
    }

    @Step("Отключить доступ к API: login = {0}")
    public void disableAPI(String login) {
        setAPIEnabled(login, APIEnabled.NO);
    }

    @Step("Доступ к API по умолчанию: login = {0}")
    public void defaultAPI(String login) {
        setAPIEnabled(login, APIEnabled.DEFAULT);
    }
    //endregion

    @Step("Установка количества баллов API: login = {0}, units = {1}")
    public void setAPIUnits(String login, int units) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setApiUnits(String.valueOf(units));
        updateClientParams(client);
    }

    @Step("[FakeGetClientParams]: login = {0}")
    public ClientFakeInfo getClientData(String login) {
        String[] fields = new String[]{"login", "uid", "ClientID"};
        ClientFakeInfo client = service().FakeGetClientParams(login, fields);
        return client;
    }

    @Step("[FakeGetClientParams]: login = {0}, fieldName = {1}")
    public ClientFakeInfo getClientDataByLogin(String login, String fieldName) {
        String[] fields = new String[]{"login", "uid", "ClientID", fieldName};
        ClientFakeInfo client = service().FakeGetClientParams(login, fields);
        return client;
    }

    //Нужен для directapi-lib
    @Step("[FakeGetClientParams]: login = {0}")
    public ClientFakeInfo getClientData(String login, String[] fields) {
        ClientFakeInfo client = service().FakeGetClientParams(login, fields);
        return client;
    }

    public boolean convertCurrency(String login, String currency, String convertType) {
        return convertCurrency(login, currency, convertType, 0);
    }

    public boolean convertCurrencyWithDelay(String login, String currency, String convertType, int delay) {
        assertThat("Delay должен быть больше нуля, иначе надо вызывать метод convertCurrency", delay, greaterThan(0));
        return convertCurrency(login, currency, convertType, delay);
    }

    /**
     * Если delay > 0 - клиент ставится в очередь на конвертацию через [delay] минут,
     * при этом сама конвертация не запускается, для этого нужен запущенный скрипт.
     * Если delay <= 0  - клиент конвертируется сразу
     */
    @Step("Выполнить конвертацию клиента (login = {0}) в валюту {1} методом {2} через {3} мин.")
    private boolean convertCurrency(String login, String currency, String convertType, int delay) {
        ConvertCurrencyClientFakeInfo convertCurrencyClientFakeInfo = new ConvertCurrencyClientFakeInfo();
        convertCurrencyClientFakeInfo.setAddConvertCurrencyQueue(1);
        convertCurrencyClientFakeInfo.setConvertType(convertType);
        convertCurrencyClientFakeInfo.setLogin(login);
        convertCurrencyClientFakeInfo.setTargetCurrency(currency);
        if (currency.equals("RUB")) {
            convertCurrencyClientFakeInfo.setSetNDS(20f);
        } else {
            convertCurrencyClientFakeInfo.setSetNDS(0f);
        }
        if (delay > 0) {
            convertCurrencyClientFakeInfo.setDelayConvert(delay);
        } else {
            convertCurrencyClientFakeInfo.setForceConvert("1");
        }
        boolean result = updateService().FakeConvertCurrencyClient(convertCurrencyClientFakeInfo);
        assumeThat("конвертация прошла успешно", result, is(true));
        return result;
    }

    @Step("Установка флага allow_create_scamp_by_subclient: login = {0}, value = {1}")
    public void setAllowCreateSelfCampaigns(String login, String value) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setAllowCreateScampBySubclient(value);
        updateClientParams(client);
    }

    @Step("Разрешить создание самостоятельных кампаний {0}")
    public void enableToCreateSelfCampaigns(String login) {
        setAllowCreateSelfCampaigns(login, Status.YES);
    }

    @Step("Запретить создание самостоятельных кампаний {0}")
    public void disableToCreateSelfCampaigns(String login) {
        setAllowCreateSelfCampaigns(login, Status.NO);
    }

    /**
     * Устанавливает клиенту НДС
     *
     * @param login   логин клиента
     * @param VATRate НДС
     */
    @Step("Установить величину НДС для клиента (login = {0}) в размере {1}")
    public boolean setVATRate(String login, double VATRate) {
        VATRateInfo vatRateInfo = new VATRateInfo();
        vatRateInfo.setLogin(login);
        vatRateInfo.setvATRate(VATRate);
        return updateService().FakeBalanceNotificationNDS(new VATRateInfo[]{vatRateInfo});
    }

    @Step("Установить величину НДС для клиента (login = {0}) в размере {1}, date_from = {2}, date_to = {3}")
    public boolean setVATRate(VATRateInfo... vatRateInfos) {
        return updateService().FakeBalanceNotificationNDS(vatRateInfos);
    }

    public void enableToCreateSubClients(String agencyLogin) {
        setAgencyCreateSubClients(agencyLogin, Status.YES);
    }

    @Step("Установить ограничение на число объявлений для клиента (login = {0}) в размере {1}")
    public void setBannerCountLimit(String login, int bannerCount) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setBannerCountLimit(bannerCount);
        updateClientParams(client);
    }

    @Step("Установить ограничение на число объявлений для клиента (login = {0}) в размере {2}")
    public void setBannerCountLimit(String login, String uid, int bannerCount) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setPassportID(uid);
        client.setLogin(login);
        client.setBannerCountLimit(bannerCount);
        updateClientParams(client);
    }

    @Step("Установить ограничение на число кампаний для клиента (login = {0}) в размере {1}")
    public void setCampaignCountLimit(String login, int campaignCount) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setCampCountLimit(campaignCount);
        updateClientParams(client);
    }

    @Step("Установить ограничение на число кампаний для клиента (login = {0}) в размере {2}")
    public void setCampaignCountLimit(String login, String uid, int campaignCount) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setPassportID(uid);
        client.setLogin(login);
        client.setCampCountLimit(campaignCount);
        updateClientParams(client);
    }

    @Step("Установить ограничение на число незаархивированных кампаний для клиента (login = {0}) в размере {1}")
    public void setUnarchivedCampaignCountLimit(String login, int campaignCount) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setUnarcCampCountLimit(campaignCount);
        updateClientParams(client);
    }

    @Step("Установить ограничение на число незаархивированных кампаний для клиента (login = {0}) в размере {2}")
    public void setUnarchivedCampaignCountLimit(String login, String uid, int campaignCount) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setPassportID(uid);
        client.setLogin(login);
        client.setUnarcCampCountLimit(campaignCount);
        updateClientParams(client);
    }

    @Step("Установить Создания субклиентов через API со статусом {1} для агенства = {0}")
    public void setAgencyCreateSubClients(String agencyLogin, String value) {
        //allow_create_subclients
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(agencyLogin);
        client.setAllowCreateSubClients(value);
        updateClientParams(client);
    }

    //region Enable/Disable wallet
    public void enableAgencyWallet(String agencyLogin) {
        setAgencyWallet(agencyLogin, Status.YES);
    }

    public void disableAgencyWallet(String agencyLogin) {
        setAgencyWallet(agencyLogin, Status.NO);
    }

    @Step("[FakeSetAllowBudgetAccountForAgency]: Установить Использование общего счета со статусом {1} для агенства = {0}")
    public void setAgencyWallet(String agencyLogin, String value) {
        service().FakeSetAllowBudgetAccountForAgency(agencyLogin, value);
    }

    //endregion

    @Step("Перевод клиента (login = {0}) в шард {1}")
    public void reshardUser(String login, int shard) {
        if (getUserShard(login) != shard) {
            service().ReshardUser(login, shard);
        }
    }

    public void reshardUser(String login, ShardNumbers shard) {
        reshardUser(login, shard.getShardNumber());
    }

    @Step("Перевод клиента (clientID = {0}) в шард {1}")
    public void reshardUser(int clientID, int shard) {
        if (getUserShard(clientID) != shard) {
            service().ReshardUser(clientID, shard);
        }
    }

    public void reshardUser(int clientID, ShardNumbers shard) {
        reshardUser(clientID, shard.getShardNumber());
    }

    @Step("Получение номера шарда клиента (login = {0})")
    public int getUserShard(String login) {
        int shard = service().GetUserShard(login);
        return shard;
    }

    @Step("Получение номера шарда клиента (cliendID = {0})")
    public Integer getUserShard(int clientID) {
        return service().GetUserShard(clientID);
    }

    //region Geo allowed flag

    @Step("Установить ApiGeoAllowed = {1}, для = {0}")
    public void setApiGeoAllowed(String login, String value) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setApiGeoAllowed(value);
        updateClientParams(client);
    }

    public void enableGeo(String login) {
        setApiGeoAllowed(login, Status.YES);
    }

    public void disableGeo(String login) {
        setApiGeoAllowed(login, Status.NO);
    }
    //endregion

    @Step("Установить AllowEditCampaigns = {1}, для = {0}")
    public void setAllowEditCampaigns(String login, String value) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setAllowEditCampaigns(value);
        updateClientParams(client);
    }

    public void enableAllowEditCampaigns(String login) {
        setAllowEditCampaigns(login, "1");
    }

    public void disableAllowEditCampaigns(String login) {
        setAllowEditCampaigns(login, "0");
    }

    @Step("Установить ImagePoolLimit = {1}, для = {0}")
    public void setImagePoolLimit(String login, Integer poolSize) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setImagePoolLimit(poolSize);
        updateClientParams(client);
    }

    @Step("Установить disallow_money_transfer = {1}, для = {0}")
    public void setDisallowMoneyTransfer(String login, Integer value) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setDisallowMoneyTransfer(value);
        updateClientParams(client);
    }

    public void enableDisallowMoneyTransfer(String login) {
        setDisallowMoneyTransfer(login, 1);
    }

    public void disableDisallowMoneyTransfer(String login) {
        setDisallowMoneyTransfer(login, 0);
    }

    @Step("Установка клиенту clientID = {0} скидки {1}")
    public void setDiscount(String clientID, Integer discount) {
        HashMap<String, String> params = new HashMap();
        params.put(clientID, discount.toString());
        updateService().SetDiscount(params);
    }

    @Step("Установка клиенту clientID = {0} скидок {1}")
    public void setDiscount(String clientID, SetDiscountInfo... setDiscountInfos) {
        HashMap<String, Object> params = new HashMap<>();
        params.put(clientID, setDiscountInfos);
        updateService().SetDiscount(params);
    }

    @Step("Устанавливаем параметру 'Показывать тизер первой помощи' значение {1} для пользователя{0}")
    public void setShowFaTeaserToUser(String login, String status) {
        ClientFakeInfo clientInfo = new ClientFakeInfo();
        clientInfo.setLogin(login);
        clientInfo.setShowFaTeaser(status);
        updateClientParams(clientInfo);
    }

    @Step("Снятие субклиента (clientID = {1}) с обслуживания агентством (clientID = {0})")
    public void fakeRemoveAgencyClientRelation(int agencyID, int clientID) {
        service().FakeRemoveAgencyClientRelation(agencyID, clientID);
    }

    @Step("[ReshardUser]")
    public void reshardUserWithLock(final String login, final int shard) {
        if (!new HazelcastProperties().isDisabled()) {
            String lockName = "api_sharding_" + login;
            Lock lock = getHazelcast().getLock(lockName);
            try {
                lock.lock();
                log().info("Лок " + lockName + " взят!");
                reshardUser(login, shard);
            } finally {
                lock.unlock();
                log().info("Лок " + lockName + " отпущен!");
            }
        } else {
            log().info("Hazelcast отключен!");
            reshardUser(login, shard);
        }
    }

    public void reshardUserWithLock(final String login, final ShardNumbers shard) {
        reshardUserWithLock(login, shard.getShardNumber());
    }

    private static HazelcastInstance getHazelcast() {
        if (hz == null) {
            hz = HazelcastClient.newHazelcastClient();
        }
        return hz;
    }

    @Step("Сброс счетчика израсходованных баллов API5 (login = {0})")
    public int fakeClearClientSpentUnits(String login) {
        String clientId = getClientData(login).getClientID();
        assumeThat("получили корректный ClientId", clientId, notNullValue());
        return service().FakeClearClientSpentUnits(Integer.valueOf(clientId));
    }

    @Step("Получение количества оставшихся баллов API5 (login = {0})")
    public int fakeClientUnitsBalance(String login) {
        return service().FakeClientUnitsBalance(Integer.valueOf(getClientData(login).getClientID()));
    }

    @Step("Списание у клиента {0} {1} баллов API5")
    public int fakeWithdrawClientUnits(String login, int amount) {
        return service().FakeWithdrawClientUnits(Integer.valueOf(getClientData(login).getClientID()), amount);
    }

    @Step("Установка флага нерезидента из представителя: login = {0}, value = {1}")
    public void setNotResident(String login, String value) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setNotResident(value);
        updateClientParams(client);
    }

    @Step("Установка флага нерезидена из клиента для оплат: login = {0}, value = {1}")
    public void setNonResidentClient(String login, String value) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setNonResidentClient(value);
        updateClientParams(client);
    }

    @Step("[FakeCreateClient]: Создать клиента с логином {0} и валютой {3}")
    public Integer fakeCreateClient(String login, String password, String name, String surname, Currency currency) {
        return service().FakeCreateClient(login, password, name, surname, currency.value());
    }

    public Integer fakeCreateClient(String login, String password, Currency currency) {
        return fakeCreateClient(login, password, "Вася", "Пупкин", currency);
    }

    @Step("Установка флага force_currency_convert_accepted_at: login = {0}, value = {1}")
    public void setForceCurrencyConvertAcceptedAt(String login, String value) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setForceCurrencyConvertAcceptedAt(value);
        updateClientParams(client);
    }

    @Step("Установить значение кармы для клиента (login = {0}) в размере {1}")
    public void setPassportKarma(String login, String karma) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setPassportKarma(karma);
        updateClientParams(client);
    }

    public String getPassportKarma(String login) {
        ClientFakeInfo client = getClientDataByLogin(login, "passport_karma");
        assumeThat("passport_karma не null", client.getPassportKarma(), notNullValue());
        return client.getPassportKarma();
    }

    @Step("Установить api_reports_limit = {1}, для клиента login = {0}")
    public void setApiReportsLimit(String login, Integer apiReportsLimit) {
        ClientFakeInfo client = new ClientFakeInfo();
        client.setLogin(login);
        client.setApiReportsLimit(apiReportsLimit);
        updateClientParams(client);
    }
}

