package ru.yandex.autotests.directapi.darkside.steps.fakesteps;

import org.apache.commons.beanutils.BeanMap;
import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.HashMap;

import static ch.lambdaj.Lambda.convert;

public class EventLogFakeSteps extends BaseFakeSteps {

    @Step("[AddEvent]")
    public boolean addEvents(Object... events) {   //TODO EventsLogItemMap
        //Конвертируем в HashMap для того чтобы названия полей начиналось с большой буквы
        return updateService().AddEvents((HashMap[]) JsonUtils.convertTo(events, HashMap[].class));
    }

    public <T extends BeanMap> boolean addEvents(T... events) {   //TODO EventsLogItemMap
        Object[] params = convert(events, new BeanMapToBeanConverter<>()).toArray(new Object[0]);
        return addEvents(params);
    }

}
