package ru.yandex.autotests.directapi.darkside.steps.fakesteps;

import java.util.Map;

import com.googlecode.jsonrpc4j.JsonRpcParam;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.TakeRedisLockResult;
import ru.yandex.qatools.allure.annotations.Step;

/*
* todo javadoc
*/
public class FakeAdminSteps extends BaseFakeSteps {

    @Step("[FakeAdmin]: FakeSetAllowBudgetAccountForAgency login {0} value {1}")
    public boolean setAllowBudgetAccountForAgency(String login, String value) {
        return service().FakeSetAllowBudgetAccountForAgency(login, value);
    }

    @Step("[FakeAdmin]: TakeRedisLock key {0} TTL {1}")
    public TakeRedisLockResult takeRedisLock(String key, long ttl) {
        return service().TakeRedisLock(key, ttl);
    }

    @Step("[FakeAdmin]: DropRedisLock key {0}")
    public void dropRedisLock(Object lock) {
        service().DropRedisLock(lock);
    }

    @Step("[FakeAdmin]: send campaign {0} to balance")
    public void sendCampaignToBalance(long cid) {
        Map response = service().SendCampaignToBalance(cid);
        Object balanceResponse = response.getOrDefault("balance_res", 0);
        boolean success = Long.parseLong(balanceResponse.toString()) == 1;
        if (!success) {
            log().info("Send campaign to balance failed, IntAPI response: " + response);
        }
    }
}
