package ru.yandex.autotests.directapi.darkside.steps.fakesteps;

import java.util.concurrent.Callable;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.qatools.allure.annotations.Step;

public class GroupsFakeSteps extends BaseFakeSteps {
    /**
     * Выставляет результат модерации группы.
     * ppc.phrases:statusModerate - enum('new', 'sent', 'sending', 'ready', 'yes', 'no')
     * <p>
     * На отправку в БК не влияет. Требуется выяснить, на что он влияет (!).
     *
     * @param pid    pid
     * @param status статус enum('new', 'sent', 'sending', 'ready', 'yes', 'no')
     */
    @Step("[FakeGroupParams]: установить значение statusModerate = {1} для группы pid = {0}")
    public void setStatusModerate(Long pid, String status) {
        GroupFakeInfo groupFakeInfo = new GroupFakeInfo();
        groupFakeInfo.setPid(pid);
        groupFakeInfo.setStatusModerate(status);
        updateGroupParams(groupFakeInfo);
    }

    /**
     * Выставляет флаг возможности отправки в БК
     * ppc.phrases:statusPostModerate - enum('new', 'sent', 'ready', 'yes', 'no', 'rejected')
     *
     * @param pid    pid
     * @param status статус enumenum('new', 'sent', 'ready', 'yes', 'no', 'rejected')
     */
    @Step("[FakeGroupParams]: установить значение statusPostModerate = {1} для группы pid = {0}")
    public void setStatusPostModerate(Long pid, String status) {
        GroupFakeInfo groupFakeInfo = new GroupFakeInfo();
        groupFakeInfo.setPid(pid);
        groupFakeInfo.setStatusPostModerate(status);
        updateGroupParams(groupFakeInfo);
    }

    @Step("[FakeGroupParams]: сделать группу pid = {0} полностью промодерированной")
    public void makeGroupFullyModerated(Long pid) {
        String status = Status.YES;

        GroupFakeInfo groupFakeInfo = getGroupParams(pid);
        groupFakeInfo.setPid(pid);
        groupFakeInfo.setStatusModerate(status);
        groupFakeInfo.setStatusPostModerate(status);
        updateGroupParams(groupFakeInfo);
    }

    @Step("[FakeGroupParams]: обновить параметры групп")
    public void updateGroupParams(GroupFakeInfo... groupFakeInfos) {
        for (GroupFakeInfo groupFakeInfo : groupFakeInfos) {
            try {
                updateService().FakeGroupParams(groupFakeInfo);
            } catch (Exception e) {
                throw new DarkSideException("Ошибка INTAPI при вызове метода updateService().FakeGroupParams", e);
            }
        }
    }

    @Step("[FakeGroupParams]: получение параметров группы pid = {0}")
    public GroupFakeInfo getGroupParams(Long adGroupID) {
        try {
            return service().FakeGetGroupParams(adGroupID);
        } catch (Exception e) {
            throw new DarkSideException("Ошибка INTAPI при вызове метода service().FakeGroupParams", e);
        }

    }

    @Deprecated
    @Step("[FakeGroupParams]: установить значение statusModerate = {1} для adGroupID = {0}")
    public void setGroupFakeStatusModerate(Long adGroupID, String status) {
        GroupFakeInfo groupFakeInfo = getGroupParams(adGroupID);
        groupFakeInfo.setStatusModerate(status);
        updateGroupParams(groupFakeInfo);
    }

    @Deprecated
    @Step("[FakeGroupParams]: установить значение statusPostModerate = {1} для groupID = {0}")
    public void setGroupFakeStatusPostModerate(Long adGroupID, String status) {
        GroupFakeInfo groupFakeInfo = getGroupParams(adGroupID);
        groupFakeInfo.setStatusPostModerate(status);
        updateGroupParams(groupFakeInfo);
    }

    @Step("[FakeGroupParams]: установить значение statusBsSynced = {1} для adGroupID = {0}")
    public void setGroupFakeStatusBsSynced(Long adGroupID, String status) {
        GroupFakeInfo groupFakeInfo = getGroupParams(adGroupID);
        groupFakeInfo.setStatusBsSynced(status);
        updateGroupParams(groupFakeInfo);
    }

    @Step("[FakeGroupParams]: установить значение StatusShowsForecast = {1} для adGroupID = {0}")
    public void setGroupFakeStatusShowsForecast(Long adGroupID, String status) {
        GroupFakeInfo groupFakeInfo = getGroupParams(adGroupID);
        groupFakeInfo.setStatusShowsForecast(status);
        updateGroupParams(groupFakeInfo);
    }

    @Step("[FakeGroupParams]: установить значение statusAutobudgetShow = {1} для adGroupID = {0}")
    public void setStatusAutobudgetShow(Long adGroupID, String status) {
        GroupFakeInfo groupFakeInfo = getGroupParams(adGroupID);
        groupFakeInfo.setStatusAutobudgetShow(status);
        updateGroupParams(groupFakeInfo);
    }

    @Step("Установить LastChange {1} для группы groupID = {0}")
    public void setLastChange(Long groupID, String dateTime) {
        GroupFakeInfo group = new GroupFakeInfo();
        group.setPid(groupID);
        group.setLastChange(dateTime);
        updateGroupParams(group);
    }

    public Callable<String> lastChangeIs(final Long adGroupID) {
        return new Callable<String>() {
            @Override
            public String call() throws Exception {
                return getGroupParams(adGroupID).getLastChange();
            }
        };
    }

    public Callable<Boolean> statusBsSyncedIs(Long pid, String statusBsSynced) {
        return () -> getGroupParams(pid).getStatusBsSynced().equals(statusBsSynced);
    }
}
