package ru.yandex.autotests.directapi.darkside.steps.fakesteps;

import java.util.List;

import ru.yandex.autotests.directapi.darkside.clients.IntapiJsonRpcClient;
import ru.yandex.autotests.directapi.darkside.connection.DarksideConfig;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.FakeAdminService;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.MailLogsRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.MailLogsResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.MailSmsService;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.SmsLogsRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.SmsLogsResponse;
import ru.yandex.qatools.allure.annotations.Step;

public class MailSmsFakeSteps extends BaseFakeSteps {

    private MailSmsService service;

    @Override
    public void init(DarksideConfig context) {
        super.init(context);
        IntapiJsonRpcClient client = new IntapiJsonRpcClient(context);
        service = client.getServiceWithOneComplexParam(
                FakeAdminService.SERVICE_NAME, MailSmsService.class, true);
    }

    @Step("[ShowMailLogs]: показать информацию об отправленных письмах")
    public List<MailLogsResponse> showMailLogs(MailLogsRequest request) {
        return service.ShowMailLogs(request);
    }

    @Step("[ShowSmsLogs]: показать информацию об отправленных смс")
    public List<SmsLogsResponse> showSmsLogs(SmsLogsRequest request) {
        return service.ShowSmsLogs(request);
    }
}
