package ru.yandex.autotests.direct.db.beans.UserOptionsModel;

//Task: TESTIRT-9250.

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;

import java.io.IOException;

public class UserOptionsModel {
    @JsonProperty("hide_recommendations_email_teaser")
    private String emailTeaser;

    @JsonProperty("autobroker")
    private Integer autobroker;

    @JsonProperty("budget_teaser")
    private String budgetTeaser;

    @JsonProperty("show_favorite_campaigns_only")
    private Boolean showFavoriteCampaignsOnly;

    @JsonProperty("show_my_campaigns_only")
    private Boolean showMyCampaignsOnly;

    @JsonProperty("stat_periods")
    private String statPeriods;

    @JsonProperty("campaigns_sort")
    private CampaignsSort campaignsSort;

    @JsonProperty("word_suggestions")
    private Boolean wordSuggestions;

    public CampaignsSort getCampaignsSort() {
        return campaignsSort;
    }

    public UserOptionsModel withCampaignsSort(CampaignsSort campaignsSort) {
        this.campaignsSort = campaignsSort;
        return this;
    }

    public Integer getAutobroker() {
        return autobroker;
    }

    public UserOptionsModel withAutobroker(Integer autobroker) {
        this.autobroker = autobroker;
        return this;
    }

    public String getBudgetTeaser() {
        return budgetTeaser;
    }

    public UserOptionsModel withBudgetTeaser(String budgetTeaser) {
        this.budgetTeaser = budgetTeaser;
        return this;
    }

    public Boolean getShowFavoriteCampaignsOnly() {
        return showFavoriteCampaignsOnly;
    }

    public UserOptionsModel withShowFavoriteCampaignsOnly(Boolean showFavoriteCampaignsOnly) {
        this.showFavoriteCampaignsOnly = showFavoriteCampaignsOnly;
        return this;
    }

    public Boolean getShowMyCampaignsOnly() {
        return showMyCampaignsOnly;
    }

    public UserOptionsModel withShowMyCampaignsOnly(Boolean showMyCampaignsOnly) {
        this.showMyCampaignsOnly = showMyCampaignsOnly;
        return this;
    }

    public String getStatPeriods() {
        return statPeriods;
    }

    public UserOptionsModel withStatPeriods(String statPeriods) {
        this.statPeriods = statPeriods;
        return this;
    }

    public Boolean getWordSuggestions() {
        return wordSuggestions;
    }

    public UserOptionsModel withWordSuggestions(Boolean wordSuggestions) {
        this.wordSuggestions = wordSuggestions;
        return this;
    }

    public UserOptionsModel withEmailTeaser(String emailTeaser) {
        this.emailTeaser = emailTeaser;
        return this;
    }

    public String getEmailTeaser() {
        return emailTeaser;
    }

    @Override
    public String toString() {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        try {
            return mapper.writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static UserOptionsModel fromString(String text) {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        try {
            return mapper.readValue(text, UserOptionsModel.class);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}
