package ru.yandex.autotests.direct.db.beans.ads.internal;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;

public class BannersInternalTemplateVariablesBuilder {

    private List<BannersInternalTemplateVariables> templateVariables = new ArrayList<>();

    public static BannersInternalTemplateVariablesBuilder init() {
        return new BannersInternalTemplateVariablesBuilder();
    }

    public BannersInternalTemplateVariablesBuilder addTemplateVariable(Long templateResourceId, String value) {
        templateVariables.add(new BannersInternalTemplateVariables()
                .withTemplateResourceId(templateResourceId)
                .withInternalValue(value));
        return this;
    }

    public String buildJson() {
        return JsonUtils.toString(templateVariables);
    }

    public List<BannersInternalTemplateVariables> build() {
        return templateVariables;
    }
}
