package ru.yandex.autotests.direct.db.beans.campaign;

import java.math.BigDecimal;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

public class StrategyData extends StrategyDataBase {

    @SerializedName("goal_id")
    private String goalId;

    public String getGoalId() {
        return goalId;
    }

    public void setGoalId(String goalId) {
        this.goalId = goalId;
    }

    public StrategyData withGoalId(String goalId) {
        this.goalId = goalId;
        return this;
    }

    public StrategyData withSum(Double sum) {
        this.sum = sum;
        return this;
    }

    public StrategyData withBid(Double bid) {
        this.bid = bid;
        return this;
    }

    public StrategyData withLimitClicks(Integer limitClicks) {
        this.limitClicks = limitClicks;
        return this;
    }

    public StrategyData withAvgBid(Double avgBid) {
        this.avgBid = avgBid;
        return this;
    }

    public StrategyData withAvgCpa(Double avgCpa) {
        this.avgCpa = avgCpa;
        return this;
    }

    public StrategyData withAvgCpi(Double avgCpi) {
        this.avgCpi = avgCpi;
        return this;
    }

    public StrategyData withRoiCoef(Double roiCoef) {
        this.roiCoef = roiCoef;
        return this;
    }

    public StrategyData withPlace(StrategyPlace place) {
        this.place = place;
        return this;
    }

    public StrategyData withFilterAvgBid(BigDecimal filterAvgBid) {
        this.filterAvgBid = filterAvgBid;
        return this;
    }

    public StrategyData withFilterAvgCpa(BigDecimal filterAvgCpa) {
        this.filterAvgCpa = filterAvgCpa;
        return this;
    }

    public StrategyData withName(CampaignsStrategyName name) {
        this.name = name.getLiteral();
        return this;
    }

    public StrategyData withVersion(Integer version) {
        this.version = version;
        return this;
    }

    public StrategyData withReserveReturn(Integer reserveReturn) {
        this.reserveReturn = reserveReturn;
        return this;
    }

    public StrategyData withProfitability(Double profitability) {
        this.profitability = profitability;
        return this;
    }

    public StrategyData withAvgCpm(Double avgCpm) {
        this.avgCpm = avgCpm;
        return this;
    }

    public StrategyData withBudget(Double budget) {
        this.budget = budget;
        return this;
    }

    public StrategyData withStart(String start) {
        this.start = start;
        return this;
    }

    public StrategyData withFinish(String finish) {
        this.finish = finish;
        return this;
    }

    public StrategyData withAutoProlongation(Integer autoProlongation) {
        this.autoProlongation = autoProlongation;
        return this;
    }

    public StrategyData withPayForConversion(Integer payForConversion) {
        this.payForConversion = payForConversion;
        return this;
    }

    public StrategyData withCrr(Integer crr) {
        setCrr(crr);
        return this;
    }

    public static StrategyData fromString(String jsonString) {
        return JsonUtils.getObject(jsonString, StrategyData.class);
    }

}
