package ru.yandex.autotests.direct.db.beans.campaign;

import java.math.BigDecimal;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.direct.db.beans.campaign.StrategyPlace;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

class StrategyDataBase {

    @SerializedName("sum")
    protected Double sum;

    @SerializedName("bid")
    protected Double bid;

    @SerializedName("limit_clicks")
    protected Integer limitClicks;

    @SerializedName("avg_bid")
    protected Double avgBid;

    @SerializedName("avg_cpa")
    protected Double avgCpa;

    @SerializedName("avg_cpi")
    protected Double avgCpi;

    @SerializedName("avg_cpm")
    protected Double avgCpm;

    @SerializedName("roi_coef")
    protected Double roiCoef;

    @SerializedName("reserve_return")
    protected Integer reserveReturn;

    @SerializedName("profitability")
    protected Double profitability;

    @SerializedName("place")
    protected StrategyPlace place;

    @SerializedName("filter_avg_bid")
    protected BigDecimal filterAvgBid;

    @SerializedName("filter_avg_cpa")
    protected BigDecimal filterAvgCpa;

    @SerializedName("name")
    protected String name;

    @SerializedName("version")
    protected Integer version;

    @SerializedName("budget")
    protected Double budget;

    @SerializedName("start")
    protected String start;

    @SerializedName("finish")
    protected String finish;

    @SerializedName("auto_prolongation")
    protected Integer autoProlongation;

    @SerializedName("pay_for_conversion")
    protected Integer payForConversion;

    @SerializedName("crr")
    protected Integer crr;

    public Double getSum() {
        return sum;
    }

    public void setSum(Double sum) {
        this.sum = sum;
    }

    public Double getBid() {
        return bid;
    }

    public void setBid(Double bid) {
        this.bid = bid;
    }

    public Integer getLimitClicks() {
        return limitClicks;
    }

    public void setLimitClicks(Integer limitClicks) {
        this.limitClicks = limitClicks;
    }

    public Double getAvgBid() {
        return avgBid;
    }

    public void setAvgBid(Double avgBid) {
        this.avgBid = avgBid;
    }

    public Double getAvgCpa() {
        return avgCpa;
    }

    public void setAvgCpa(Double avgCpa) {
        this.avgCpa = avgCpa;
    }

    public Double getAvgCpi() {
        return avgCpi;
    }

    public void setAvgCpi(Double avgCpi) {
        this.avgCpi = avgCpi;
    }

    public Double getRoiCoef() {
        return roiCoef;
    }

    public void setRoiCoef(Double roiCoef) {
        this.roiCoef = roiCoef;
    }

    public StrategyPlace getPlace() {
        return place;
    }

    public void setPlace(StrategyPlace place) {
        this.place = place;
    }

    public BigDecimal getFilterAvgBid() {
        return filterAvgBid;
    }

    public void setFilterAvgBid(BigDecimal filterAvgBid) {
        this.filterAvgBid = filterAvgBid;
    }

    public BigDecimal getFilterAvgCpa() {
        return filterAvgCpa;
    }

    public void setFilterAvgCpa(BigDecimal filterAvgCpa) {
        this.filterAvgCpa = filterAvgCpa;
    }

    public String getName() {
        return name;
    }

    public void setName(CampaignsStrategyName name) {
        this.name = name.getLiteral();
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getReserveReturn() {
        return reserveReturn;
    }

    public void setReserveReturn(Integer reserveReturn) {
        this.reserveReturn = reserveReturn;
    }

    public Double getProfitability() {
        return profitability;
    }

    public void setProfitability(Double profitability) {
        this.profitability = profitability;
    }

    public Double getAvgCpm() {
        return avgCpm;
    }

    public void setAvgCpm(Double avgCpm) {
        this.avgCpm = avgCpm;
    }

    public Double getBudget() {
        return budget;
    }

    public void setBudget(Double budget) {
        this.budget = budget;
    }

    public String getStart() {
        return start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getFinish() {
        return finish;
    }

    public void setFinish(String finish) {
        this.finish = finish;
    }

    public Integer getAutoProlongation() {
        return autoProlongation;
    }

    public void setAutoProlongation(Integer autoProlongation) {
        this.autoProlongation = autoProlongation;
    }

    public Integer getPayForConversion() {
        return payForConversion;
    }

    public void setPayForConversion(Integer payForConversion) {
        this.payForConversion = payForConversion;
    }

    public Integer getCrr() {
        return crr;
    }

    public void setCrr(Integer crr) {
        this.crr = crr;
    }

    @Override
    public String toString() {
        return JsonUtils.toLowCaseString(this);
    }

    public JsonElement toJsonElement() {
        return new Gson().toJsonTree(this);
    }
}
