package ru.yandex.autotests.direct.db.beans.campaign;

import java.math.BigDecimal;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

public class StrategyDataJava extends StrategyDataBase {

    @SerializedName("goal_id")
    private Long goalId;

    public Long getGoalId() {
        return goalId;
    }

    public void setGoalId(Long goalId) {
        this.goalId = goalId;
    }

    public StrategyDataJava withGoalId(Long goalId) {
        this.goalId = goalId;
        return this;
    }

    public StrategyDataJava withSum(Double sum) {
        this.sum = sum;
        return this;
    }

    public StrategyDataJava withBid(Double bid) {
        this.bid = bid;
        return this;
    }

    public StrategyDataJava withLimitClicks(Integer limitClicks) {
        this.limitClicks = limitClicks;
        return this;
    }

    public StrategyDataJava withAvgBid(Double avgBid) {
        this.avgBid = avgBid;
        return this;
    }

    public StrategyDataJava withAvgCpa(Double avgCpa) {
        this.avgCpa = avgCpa;
        return this;
    }

    public StrategyDataJava withAvgCpi(Double avgCpi) {
        this.avgCpi = avgCpi;
        return this;
    }

    public StrategyDataJava withRoiCoef(Double roiCoef) {
        this.roiCoef = roiCoef;
        return this;
    }

    public StrategyDataJava withPlace(StrategyPlace place) {
        this.place = place;
        return this;
    }

    public StrategyDataJava withFilterAvgBid(BigDecimal filterAvgBid) {
        this.filterAvgBid = filterAvgBid;
        return this;
    }

    public StrategyDataJava withFilterAvgCpa(BigDecimal filterAvgCpa) {
        this.filterAvgCpa = filterAvgCpa;
        return this;
    }

    public StrategyDataJava withName(CampaignsStrategyName name) {
        this.name = name.getLiteral();
        return this;
    }

    public StrategyDataJava withVersion(Integer version) {
        this.version = version;
        return this;
    }

    public StrategyDataJava withReserveReturn(Integer reserveReturn) {
        this.reserveReturn = reserveReturn;
        return this;
    }

    public StrategyDataJava withProfitability(Double profitability) {
        this.profitability = profitability;
        return this;
    }

    public StrategyDataJava withAvgCpm(Double avgCpm) {
        this.avgCpm = avgCpm;
        return this;
    }

    public StrategyDataJava withBudget(Double budget) {
        this.budget = budget;
        return this;
    }

    public StrategyDataJava withStart(String start) {
        this.start = start;
        return this;
    }

    public StrategyDataJava withFinish(String finish) {
        this.finish = finish;
        return this;
    }

    public StrategyDataJava withAutoProlongation(Integer autoProlongation) {
        this.autoProlongation = autoProlongation;
        return this;
    }

    public StrategyDataJava withPayForConversion(Integer payForConversion) {
        this.payForConversion = payForConversion;
        return this;
    }

    public StrategyDataJava withCrr(Integer crr) {
        setCrr(crr);
        return this;
    }

    public static StrategyDataJava fromString(String jsonString) {
        return JsonUtils.getObject(jsonString, StrategyDataJava.class);
    }

}
