package ru.yandex.autotests.direct.db.beans.creatives;

public enum CreativeTemplate {

    MANY_OFFERS_ONE_DESCRIPTION_AND_MOSAIC_728x90(320, 728, 90,
            "Динамический баннер 728х90 \"Много товаров с одним описанием и мозаикой\""),
    MANY_OFFERS_MANY_DESCRIPTIONS_AND_CAROUSEL_240x400(330, 240, 400,
            "Динамический баннер 240х400 \"Много товаров с описаниями и каруселью\""),
    MANY_OFFERS_ONE_DESCRIPTION_AND_MOSAIC_240x400(331, 240, 400,
            "Динамический баннер 240х400 \"Много товаров с одним описанием и мозаикой\""),
    ONE_OFFER_ONE_DESCRIPTION_AND_CAROUSEL_240x400(332, 240, 400,
            "Динамический баннер 240х400 \"Один товар крупно с описанием и каруселью\""),
    MANY_OFFERS_MANY_DESCRIPTIONS_AND_CAROUSEL_728x90(333, 728, 90,
            "Динамический баннер 728х90 \"Много товаров с описаниями и каруселью\""),
    MANY_OFFERS_ONE_ONMOSEOVER_DESCRIPTION_AND_CAROUSEL_300x250(334, 300, 250,
            "Динамический баннер 300x250 \"Много товаров крупно с описанием по наведению и каруселью\""),
    MANY_OFFERS_MANY_DESCRIPTIONS_AND_CAROUSEL_300x250(335, 300, 250,
            "Динамический баннер 300x250 \"Много товаров с описаниями и каруселью\""),
    ONE_OFFER_ONE_DESCRIPTION_AND_CAROUSEL_300x250(336, 300, 250,
            "Динамический баннер 300x250 \"Один товар крупно с описанием и каруселью\""),
    MANY_OFFERS_ONE_ONMOSEOVER_DESCRIPTION_AND_CAROUSEL_728x90(337, 728, 90,
            "Динамический баннер 728х90 \"Много товаров крупно с описанием по наведению и каруселью\"");

    private long id;
    private int width;
    private int height;
    private String description;

    CreativeTemplate(long id, int width, int height, String description) {
        this.id = id;
        this.description = description;
        this.width = width;
        this.height = height;
    }

    public long getId() {
        return id;
    }

    public String getDescription() {
        return description;
    }

    public Integer getWidth() {
        return width;
    }

    public Integer getHeight() {
        return height;
    }
}
