package ru.yandex.autotests.direct.db.beans.feeds;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

public enum FeedType {
    GOOGLE_HOTELS("GoogleHotels"),

    GOOGLE_FLIGHTS("GoogleFlights"),

    GOOGLE_MERCHANT("GoogleMerchant"),

    AUTO_RU("AutoRu"),

    YANDEX_REALTY("YandexRealty"),

    TRAVEL_BOOKING("TravelBooking"),

    CRITEO_TURKEY("CriteoTurkey"),

    ALIEXPRESS("AliExpress"),

    YANDEX_MARKET("YandexMarket"),

    YANDEX_ZEN("YandexZen"),

    ALIBABA("Alibaba"),

    TURKEY_TEKNOSA("TurkeyTeknosa"),

    TURKEY_JOLLY_TUR("TurkeyJollyTur"),

    TURKEY_CLIENT_1("TurkeyClient1"),

    TURKEY_CLIENT_2("TurkeyClient2"),

    TURKEY_CLIENT_3("TurkeyClient3"),

    TURKEY_CLIENT_4("TurkeyClient4"),

    TURKEY_CLIENT_5("TurkeyClient5"),

    TURKEY_CLIENT_6("TurkeyClient6"),

    TURKEY_CLIENT_7("TurkeyClient7"),

    TURKEY_CLIENT_8("TurkeyClient8"),

    TURKEY_CLIENT_9("TurkeyClient9"),

    TURKEY_CLIENT_10("TurkeyClient10"),

    TURKEY_CLIENT_11("TurkeyClient11"),

    TURKEY_CLIENT_12("TurkeyClient12"),

    TURKEY_CLIENT_13("TurkeyClient13"),

    TURKEY_CLIENT_14("TurkeyClient14"),

    TURKEY_CLIENT_15("TurkeyClient15"),

    TURKEY_CLIENT_16("TurkeyClient16"),

    TURKEY_CLIENT_17("TurkeyClient17"),

    TURKEY_CLIENT_18("TurkeyClient18"),

    TURKEY_CLIENT_19("TurkeyClient19"),

    TURKEY_CLIENT_20("TurkeyClient20"),

    TURKEY_CLIENT_21("TurkeyClient21"),

    TURKEY_CLIENT_22("TurkeyClient22"),

    TURKEY_CLIENT_23("TurkeyClient23"),

    TURKEY_CLIENT_24("TurkeyClient24"),

    TURKEY_CLIENT_25("TurkeyClient25"),

    YANDEX_CUSTOM("YandexCustom");

    private static final Map<String, FeedType> ENUMS = Arrays.stream(values())
            .collect(Collectors.toMap(FeedType::getTypedValue, e -> e));

    private final String typedValue;

    FeedType(String typedValue) {
        this.typedValue = typedValue;
    }

    public String getTypedValue() {
        return typedValue;
    }

    public static FeedType fromTypedValue(@Nullable String typedValue) {
        if (typedValue == null) {
            return null;
        }
        FeedType result = ENUMS.get(typedValue);
        if (result == null) {
            throw new IllegalArgumentException("Unknown enum typed value " + typedValue);
        }
        return result;
    }
}
