package ru.yandex.autotests.direct.db.beans.modcmd;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ModerationCmdQueueRecord;
import ru.yandex.autotests.httpclientlite.core.support.gson.NullValuesAdapterFactory;

@ParametersAreNonnullByDefault
public class ModCmdRecord<T> {
    private static Gson gson = (new GsonBuilder()).registerTypeAdapterFactory(new NullValuesAdapterFactory()).create();

    private ModerationCmdQueueRecord r;
    private T data;

    public static <T> ModCmdRecord<T> fromJooqRecord(ModerationCmdQueueRecord r, ModCmd<T> cmd) {
        ModCmdRecord<T> result = new ModCmdRecord<>();
        result.r = r;
        result.data = gson.fromJson(r.getData(), cmd.dataClass);
        return result;
    }

    public T getData() {
        return data;
    }
}
