package ru.yandex.autotests.direct.db.beans.mysql;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ServerUuidAndGtidExecutedContainer {
    private String serverUuid;
    private String gtidExecuted;

    public String getServerUuid() {
        return serverUuid;
    }

    public void setServerUuid(String serverUuid) {
        this.serverUuid = serverUuid;
    }

    public ServerUuidAndGtidExecutedContainer withServerUuid(String serverUuid) {
        setServerUuid(serverUuid);
        return this;
    }

    public String getGtidExecuted() {
        return gtidExecuted;
    }

    public void setGtidExecuted(String gtidExecuted) {
        this.gtidExecuted = gtidExecuted;
    }

    public ServerUuidAndGtidExecutedContainer withGtidExecuted(String gtidExecuted) {
        setGtidExecuted(gtidExecuted);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(
                "ru.yandex.direct.grid.core.entity.sync.container.ServerUuidAndGtidExecutedContainer{");
        sb.append("serverUuid=").append(serverUuid);
        sb.append(", gtidExecuted=").append(gtidExecuted);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ServerUuidAndGtidExecutedContainer that = (ServerUuidAndGtidExecutedContainer) o;
        return Objects.equals(serverUuid, that.serverUuid)
                && Objects.equals(gtidExecuted, that.gtidExecuted);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                serverUuid,
                gtidExecuted
        );
    }

}
