package ru.yandex.autotests.direct.db.beans.retargeting;

import com.google.gson.annotations.SerializedName;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.List;

public class RetargetingConditionRule {
    @SerializedName("goals")
    private List<Goal> goals;

    @SerializedName("type")
    private String type;

    @SerializedName("interest_type")
    private String interestType;

    public String getType() {
        return type;
    }

    public RetargetingConditionRule withType(String type) {
        this.type = type;
        return this;
    }

    public List<Goal> getGoals() {
        return goals;
    }

    public RetargetingConditionRule withGoals(List<Goal> goals) {
        this.goals = goals;
        return this;
    }

    public String getInterestType() {
        return interestType;
    }

    public RetargetingConditionRule withInterestType(String interestType) {
        this.interestType = interestType;
        return this;
    }

    public static RetargetingConditionRule fromString(String jsonString) {
        return JsonUtils.getObject(jsonString, RetargetingConditionRule.class);
    }


    @Override
    public String toString() {
        return JsonUtils.toLowCaseString(this);
    }
}
