package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AccountScoreRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;

import java.sql.Date;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.AccountScore.ACCOUNT_SCORE;

/**
 * Набор степов для генерации работы с таблицей ppc.account_score,
 * в которой хранится показатель качества аккаунта на ClientID в разбивке по дате.
 */
public class AccountScoreSteps extends BasePpcSteps {

    /**
     * Метод возвращает одну запись из ppc.account_score по ClientID за последнюю доступную дату
     * @param clientID id клиента
     * @return AccountScoreRecord
     */
    public AccountScoreRecord getLastAccountScore(Long clientID) {
        return exec("DB: получение последней по дате записи из таблицы ppc.account_score ClientID " + clientID,
                db -> db.selectFrom(ACCOUNT_SCORE)
                    .where(ACCOUNT_SCORE.CLIENTID.eq(clientID))
                        .orderBy(ACCOUNT_SCORE.DATE.desc())
                        .limit(1)
                        .fetchOne());
    }

    /**
     * Метод возвращает одну запись из ppc.account_score по ClientID за указанную дату
     * @param clientID id клиента
     * @param date дата за которую нужен показатель качества
     * @return AccountScoreRecord
     */
    public AccountScoreRecord getAccountScore(Long clientID, Date date) {
        return exec("DB: получение последней по дате записи из таблицы ppc.account_score ClientID " + clientID,
                db -> db.selectFrom(ACCOUNT_SCORE)
                        .where(ACCOUNT_SCORE.CLIENTID.eq(clientID).and(ACCOUNT_SCORE.DATE.eq(date)))
                        .fetchOne());
    }
}

