package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import org.jooq.util.mysql.MySQLDSL;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupBsTagsRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUP_BS_TAGS;

public class AdGroupBsTagsSteps extends BasePpcSteps {

    @Step("DB: получение записи в таблице ppc.adgroup_bs_tags по pid: {0}")
    public List<AdgroupBsTagsRecord> getAdgroupBsTagsByPid(Long pid) {
        return exec(db -> db.selectFrom(ADGROUP_BS_TAGS)
                .where(ADGROUP_BS_TAGS.PID.eq(pid))
                .fetch()
        );
    }

    @Step("DB: Добавление записи в таблицу ppc.adgroup_bs_tags")
    public void insertAdgroupBsTags(AdgroupBsTagsRecord adgroupBsTagsRecord) {
        run(db -> db.insertInto(ADGROUP_BS_TAGS)
                .set(adgroupBsTagsRecord)
                .onDuplicateKeyUpdate()
                .set(ADGROUP_BS_TAGS.PAGE_GROUP_TAGS_JSON, MySQLDSL.values(ADGROUP_BS_TAGS.PAGE_GROUP_TAGS_JSON))
                .set(ADGROUP_BS_TAGS.TARGET_TAGS_JSON, MySQLDSL.values(ADGROUP_BS_TAGS.TARGET_TAGS_JSON))
                .execute());
    }

    @Step("DB: удаление записи в таблице ppc.adgroup_bs_tags по pid: {0}")
    public void deleteAdgroupBsTags(Long pid) {
        run(db -> db.deleteFrom(ADGROUP_BS_TAGS)
                .where(ADGROUP_BS_TAGS.PID.eq(pid))
                .execute()
        );
    }
}
