package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsContentPromotionContentPromotionType;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUPS_CONTENT_PROMOTION;

public class AdGroupsContentPromotionSteps extends BasePpcSteps {

    @Step("DB: создание записи в таблице ppc.adgroups_content_promotion")
    public void addAdGroupContentPromotion(Long pid,
                                           AdgroupsContentPromotionContentPromotionType contentPromotionAdGroupType) {
        run(db -> db.insertInto(ADGROUPS_CONTENT_PROMOTION)
                .set(ADGROUPS_CONTENT_PROMOTION.PID, pid)
                .set(ADGROUPS_CONTENT_PROMOTION.CONTENT_PROMOTION_TYPE, contentPromotionAdGroupType)
                .execute()
        );
    }
}
