package ru.yandex.autotests.direct.db.steps;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupAdditionalTargetingsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsInternalRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUPS_INTERNAL;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUP_ADDITIONAL_TARGETINGS;

public class AdGroupsInternalSteps extends BasePpcSteps {

    @Step("DB: создание записи в таблице ppc.adgroups_internal")
    public void addAdGroupInternal(Long pid, Long level) {
        run(db -> db.insertInto(ADGROUPS_INTERNAL)
                .set(ADGROUPS_INTERNAL.PID, pid)
                .set(ADGROUPS_INTERNAL.LEVEL, level)
                .execute()
        );
    }

    @Step("DB: создание записи в таблице ppc.adgroup_additional_targetings")
    public void addAdGroupAdditionalTargetings(AdgroupAdditionalTargetingsRecord targetingsRecord) {
        targetingsRecord.setId(autoIncSteps().getNextAdgroupAdditionalTargetingId());
        run(db -> db.insertInto(ADGROUP_ADDITIONAL_TARGETINGS)
                .set(targetingsRecord)
                .execute()
        );
    }

    @Step("DB: получение записи из таблицы ppc.adgroup_internal (pid:{0}")
    public AdgroupsInternalRecord getAdGroupsInternal(Long pid) {
        return exec(db -> db.selectFrom(ADGROUPS_INTERNAL)
                .where(ADGROUPS_INTERNAL.PID.eq(pid))
                .fetchOne());
    }

    @Step("DB: получение записей из таблицы ppc.adgroup_additional_targetings (pid:{0})")
    public List<AdgroupAdditionalTargetingsRecord> getAdGroupAdditionalTargetings(Long pid) {
        return exec(db -> db.selectFrom(ADGROUP_ADDITIONAL_TARGETINGS)
                .where(ADGROUP_ADDITIONAL_TARGETINGS.PID.eq(pid))
                .fetch()
        );
    }

    @Step("DB: получение записей из таблицы ppc.adgroup_additional_targetings (id: {0}, pid:{1})")
    public AdgroupAdditionalTargetingsRecord getAdGroupAdditionalTargetings(Long id, Long pid) {
        return exec(db -> db.selectFrom(ADGROUP_ADDITIONAL_TARGETINGS)
                .where(ADGROUP_ADDITIONAL_TARGETINGS.ID.eq(id).and(ADGROUP_ADDITIONAL_TARGETINGS.PID.eq(pid)))
                .fetchOne()
        );
    }

    @Step("DB: удаление записи из таблицы ppc.adgroup_additional_targetings по pid: {0}")
    public void deleteAdGroupAdditionalTargetings(Collection<Long> pids) {
        run(db -> db.deleteFrom(ADGROUP_ADDITIONAL_TARGETINGS)
                .where(ADGROUP_ADDITIONAL_TARGETINGS.PID.in(pids))
                .execute()
        );
    }

    @Step("DB: выставление start_time = {1} и finish_time = {2} для группы {0}")
    public void setStartTimeAndFinishTime(Long pid, Timestamp startTime, Timestamp finishTime) {
        run(db -> db.update(ADGROUPS_INTERNAL)
                .set(ADGROUPS_INTERNAL.START_TIME, startTime)
                .set(ADGROUPS_INTERNAL.FINISH_TIME, finishTime)
                .where(ADGROUPS_INTERNAL.PID.eq(pid))
                .execute()
        );
    }

    @Step("DB: выставление rf = {1} и rfReset = {2} для группы {0}")
    public void setRfAndRfReset(Long pid, Integer rf, Integer rfReset) {
        run(db -> db.update(ADGROUPS_INTERNAL)
                .set(ADGROUPS_INTERNAL.RF, rf.shortValue())
                .set(ADGROUPS_INTERNAL.RFRESET, rfReset)
                .where(ADGROUPS_INTERNAL.PID.eq(pid))
                .execute()
        );
    }
}
