package ru.yandex.autotests.direct.db.steps;

import java.util.Collection;
import java.util.List;

import com.google.gson.Gson;

import ru.yandex.autotests.direct.db.beans.adgroups.AdGroupPageBlock;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsCpmBannerCriterionType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsDynamicStatusblgenerated;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsPerformanceStatusblgenerated;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsCpmBannerRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsDynamicRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsPerformanceRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsTextRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.GroupParamsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MinusWordsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUPS_CPM_BANNER;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUPS_DYNAMIC;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUPS_MINUS_WORDS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUPS_MOBILE_CONTENT;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUPS_PERFORMANCE;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUPS_TEXT;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUP_PAGE_TARGETS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUP_PRIORITY;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.GROUP_PARAMS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.MINUS_WORDS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.PHRASES;
import static ru.yandex.autotests.irt.testutils.allure.AllureUtils.addJsonAttachment;

/**
 * Created by buhter on 02/08/16.
 */
public class AdGroupsSteps extends BasePpcSteps {

    @Step("DB: получение записи в таблице ppc.phrases по pid: {0}")
    public PhrasesRecord getPhrases(Long pid) {
        return exec(db -> db.selectFrom(PHRASES)
                .where(PHRASES.PID.eq(pid))
                .fetchOne()
        );
    }

    @Step("DB: получение записей в таблице ppc.phrases по сid: {0}")
    public List<PhrasesRecord> getPhrasesByCid(Long cid) {
        return exec(db -> db.selectFrom(PHRASES)
                .where(PHRASES.CID.eq(cid))
                .fetch()
        );
    }

    @Step("DB: установка statusModerate={1} в таблице ppc.phrases для pid:{0}")
    public void setPhrasesStatusModerate(Long pid, PhrasesStatusmoderate statusModerate) {
        run(db -> db.update(PHRASES)
                .set(PHRASES.STATUSMODERATE, statusModerate)
                .where(PHRASES.PID.eq(pid))
                .execute()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.phrases, выставление statusModerate = {1} и statusPostModerate = {2}" +
            "для pid = {0}")
    public void setPhrasesStatusModerate(Long pid, PhrasesStatusmoderate statusModerate,
            PhrasesStatuspostmoderate statusPostModerate)
    {
        run(db -> db.update(PHRASES)
                .set(PHRASES.STATUSMODERATE, statusModerate)
                .set(PHRASES.STATUSPOSTMODERATE, statusPostModerate)
                .where(PHRASES.PID.eq(pid))
                .execute()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.phrases, выставление statusBsSynced = {1}" +
            "для pid = {0}")
    public void setPhrasesStatusBsSynced(Long pid, PhrasesStatusbssynced statusBsSynced) {
        run(db -> db.update(PHRASES)
                .set(PHRASES.STATUSBSSYNCED, statusBsSynced)
                .where(PHRASES.PID.eq(pid))
                .execute()
        );
    }

    public void makePhraseModeratedAndBsSynced(Long id) {
        setPhrasesStatuses(id, PhrasesStatusmoderate.Yes, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.Yes);
    }

    public void setPhrasesStatuses(Long id, PhrasesStatusmoderate statusModerate,
            PhrasesStatuspostmoderate statusPostModerate,
            PhrasesStatusbssynced statusBsSynced)
    {
        run(db -> db.update(PHRASES)
                .set(PHRASES.STATUSMODERATE, statusModerate)
                .set(PHRASES.STATUSPOSTMODERATE, statusPostModerate)
                .set(PHRASES.STATUSBSSYNCED, statusBsSynced)
                .where(PHRASES.PID.eq(id))
                .execute()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.phrases")
    public void updatePhrases(PhrasesRecord phrasesRecord) {
        run(db -> db.update(PHRASES)
                .set(phrasesRecord)
                .where(PHRASES.PID.eq(phrasesRecord.getPid()))
                .execute()
        );
    }

    @Step("DB: получение записи в таблице ppc.adgroups_dynamic по pid: {0}")
    public AdgroupsDynamicRecord getAdgroupsDynamic(Long pid) {
        return exec(db -> db.selectFrom(ADGROUPS_DYNAMIC)
                .where(ADGROUPS_DYNAMIC.PID.eq(pid))
                .fetchOne()
        );
    }

    @Step("DB: получение записи в таблице ppc.adgroups_performance по pid: {0}")
    public AdgroupsPerformanceRecord getAdgroupsPerformance(Long pid) {
        return exec(db -> db.selectFrom(ADGROUPS_PERFORMANCE)
                .where(ADGROUPS_PERFORMANCE.PID.eq(pid))
                .fetchOne()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.adgroups_performance")
    public void updateAdgroupsPerformance(AdgroupsPerformanceRecord record) {
        run(db -> db.update(ADGROUPS_PERFORMANCE)
                .set(record)
                .where(ADGROUPS_PERFORMANCE.PID.eq(record.getPid()))
                .execute()
        );
    }

    @Step("DB: получение записи в таблице ppc.adgroups_text по pid: {0}")
    public AdgroupsTextRecord getAdgroupsText(Long pid) {
        return exec(db -> db.selectFrom(ADGROUPS_TEXT)
                .where(ADGROUPS_TEXT.PID.eq(pid))
                .fetchOne()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.adgroups_text, выставление feed_id = {1} для pid = {0}")
    public void setAdgroupsText(Long pid, Long feedId, String filter, String useAsName, String useAsBody) {
        run(db -> db.insertInto(ADGROUPS_TEXT)
                .set(ADGROUPS_TEXT.PID, pid)
                .set(ADGROUPS_TEXT.FEED_ID, feedId)
                .set(ADGROUPS_TEXT.FILTER_DATA, filter)
                .set(ADGROUPS_TEXT.FIELD_TO_USE_AS_NAME, useAsName)
                .set(ADGROUPS_TEXT.FIELD_TO_USE_AS_BODY, useAsBody)
                .onDuplicateKeyIgnore()
                .execute()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.adgroups_text, выставление feed_id = {1} для pid = {0}")
    public void setAdgroupsTextFeedIdAndFilter(Long pid, Long feedId, String filter) {
        run(db -> db.insertInto(ADGROUPS_TEXT)
                .set(ADGROUPS_TEXT.PID, pid)
                .set(ADGROUPS_TEXT.FEED_ID, feedId)
                .set(ADGROUPS_TEXT.FILTER_DATA, filter)
                .onDuplicateKeyIgnore()
                .execute()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.adgroups_dynamic, выставление main_domain_id = {1} для pid = {0}")
    public void setAdgroupsDynamicDomainId(Long pid, Long domainId) {
        run(db -> db.update(ADGROUPS_DYNAMIC)
                .set(ADGROUPS_DYNAMIC.MAIN_DOMAIN_ID, domainId)
                .where(ADGROUPS_DYNAMIC.PID.eq(pid))
                .execute()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.adgroups_dynamic, выставление feed_id = {1} для pid = {0}")
    public void setAdgroupsDynamicFeedId(Long pid, Long feedId) {
        run(db -> db.update(ADGROUPS_DYNAMIC)
                .set(ADGROUPS_DYNAMIC.FEED_ID, feedId)
                .where(ADGROUPS_DYNAMIC.PID.eq(pid))
                .execute()
        );
    }

    @Step("DB: Конвертирование ДО-группы в ДО-группу по фиду: в таблице ppc.adgroups_dynamic, выставление main_domain_id = null, feed_id = {1} для pid = {0}")
    public void convertAdgroupDynamicToDynamicByFeed(Long pid, Long feedId) {
        run(db -> db.update(ADGROUPS_DYNAMIC)
                .set(ADGROUPS_DYNAMIC.MAIN_DOMAIN_ID, (Long) null)
                .set(ADGROUPS_DYNAMIC.FEED_ID, feedId)
                .where(ADGROUPS_DYNAMIC.PID.eq(pid))
                .execute()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.adgroups_dynamic, выставление statusBlGenerated = {1} для pid = {0}")
    public void setAdgroupsDynamicStatusBlGenerated(Long pid, AdgroupsDynamicStatusblgenerated statusBlGenerated) {
        run(db -> db.update(ADGROUPS_DYNAMIC)
                .set(ADGROUPS_DYNAMIC.STATUSBLGENERATED, statusBlGenerated)
                .where(ADGROUPS_DYNAMIC.PID.eq(pid))
                .execute()
        );
    }

    @Step("DB: Oбновление записи в таблице ppc.phrases, выставление mw_id = {1} для pid = {0}")
    public void setMwId(Long pid, Long mwId) {
        run(db -> db.update(PHRASES)
                .set(PHRASES.MW_ID, mwId)
                .where(PHRASES.PID.eq(pid))
                .execute()
        );
    }

    @Step("DB: обновление записи в таблице ppc.phrases, выставление is_bs_rarely_loaded = {1} для pid = {0}")
    public void setBsRarelyLoaded(Long pid, boolean bsRarelyLoaded) {
        run(db -> db.update(PHRASES)
                .set(PHRASES.IS_BS_RARELY_LOADED, bsRarelyLoaded ? 1 : 0)
                .where(PHRASES.PID.eq(pid))
                .execute()
        );
    }

    @Step("DB: обновление записи в таблице ppc.phrases, выставление LastChange = {1} для pid = {0}")
    public void setPhrasesLastChange(Long pid, java.sql.Timestamp lastChange) {
        run(db -> db.update(PHRASES)
                .set(PHRASES.LASTCHANGE, lastChange)
                .where(PHRASES.PID.eq(pid))
                .execute()
        );
    }

    @Step("DB: обновление записи в таблице ppc.phrases, выставление bid = {1} для pid = {0}")
    public void setPhrasesBid(Long pid, Long bid) {
        run(db -> db.update(PHRASES)
                .set(PHRASES.BID, bid)
                .where(PHRASES.PID.eq(pid))
                .execute()
        );
    }

    @Step("DB: обновление записи в таблице ppc.phrases, выставление geo = {1} для pid = {0}")
    public void setGeo(Long pid, String geo) {
        run(db -> db.update(PHRASES)
                .set(PHRASES.GEO, geo)
                .where(PHRASES.PID.eq(pid))
                .execute()
        );
    }

    @Step("DB: обновление записи в таблице ppc.phrases, выставление adgroup_type = {1} для pid = {0}")
    public void setType(long pid, PhrasesAdgroupType type) {
        run(db -> db.update(PHRASES)
                .set(PHRASES.ADGROUP_TYPE, type)
                .where(PHRASES.PID.eq(pid))
                .execute()
        );
    }

    @Step("DB: удаление записи из таблицы ppc.phrases по pid: {0}")
    public void deleteAdGroup(Long pid) {
        run(db -> db.deleteFrom(PHRASES)
                .where(PHRASES.PID.in(pid))
                .execute()
        );
    }

    @Step("DB: получение записи в таблице ppc.group_params по pid: {0}")
    public GroupParamsRecord getGroupParams(Long pid) {
        return exec(db -> db.selectFrom(GROUP_PARAMS)
                .where(GROUP_PARAMS.PID.eq(pid))
                .fetchOne()
        );
    }

    @Step("DB: запись в таблицу ppc.group_params")
    public void saveGroupParams(GroupParamsRecord groupParamsRecord) {
        String logRecord = JsonUtils.toStringLow(groupParamsRecord.intoMap());
        getLogger().info("новая запись в таблице ppc.group_params: " + logRecord);
        addJsonAttachment("новая запись", logRecord);
        exec(db -> db.insertInto(GROUP_PARAMS)
                .set(groupParamsRecord)
                .execute());
    }


    @Step("DB: добавление записи в таблице ppc.adgroups_performance для pid:{0} с feed_id:{1}")
    public void addAdGroupsPerformance(Long pid, Long feedId) {
        run(db -> db.insertInto(ADGROUPS_PERFORMANCE)
                .set(ADGROUPS_PERFORMANCE.FEED_ID, feedId)
                .set(ADGROUPS_PERFORMANCE.PID, pid)
                .set(ADGROUPS_PERFORMANCE.STATUSBLGENERATED, AdgroupsPerformanceStatusblgenerated.No)
                .execute()
        );
    }

    @Step("DB: добавление записи в таблице ppc.adgroup_page_targets для pid:{0}")
    public void addAdGroupPageTargets(Long pid, List<AdGroupPageBlock> pageBlocks) {
        run(db -> db.insertInto(ADGROUP_PAGE_TARGETS)
                .set(ADGROUP_PAGE_TARGETS.PID, pid)
                .set(ADGROUP_PAGE_TARGETS.PAGE_BLOCKS, new Gson().toJson(pageBlocks))
                .execute()
        );
    }

    @Step("DB: получение записи в таблице ppc.adgroup_mobile_content по pid: {0}")
    public AdgroupsMobileContentRecord getAdGroupMobileContent(Long pid) {
        return exec(db -> db.selectFrom(ADGROUPS_MOBILE_CONTENT)
                .where(ADGROUPS_MOBILE_CONTENT.PID.eq(pid))
                .fetchOne()
        );
    }

    @Step("DB: создание записи в таблице ppc.phrases")
    public Long addAdGroup(PhrasesRecord record, Long clientId) {
        //todo: increment shard_inc_pid.
        Long pid = shardingSteps().getNextPid(clientId);
        record.setPid(pid);

        run(db -> db.insertInto(PHRASES)
                .set(record)
                .execute()
        );
        return pid;
    }

    @Step("DB: удаление записи из таблицы ppc.adgroup_mobile_content по pid: {0}")
    public void deleteAdGroupMobileContent(Collection<Long> pids) {
        run(db -> db.deleteFrom(ADGROUPS_MOBILE_CONTENT)
                .where(ADGROUPS_MOBILE_CONTENT.PID.in(pids))
                .execute()
        );
    }

    @Step("DB: обновление записи в таблице ppc.adgroup_mobile_content")
    public void updateAdGroupMobileContent(AdgroupsMobileContentRecord record) {
        exec(db -> db.update(ADGROUPS_MOBILE_CONTENT)
                .set(record)
                .where(ADGROUPS_MOBILE_CONTENT.PID.eq(record.getPid()))
                .execute()
        );
    }

    @Step("DB: получение записи в таблице ppc.minus_words для pid = {0}")
    public String getMinusWordsMwTextByPid(Long pid) {
        return exec(db -> db.select(MINUS_WORDS.MW_TEXT)
                .from(PHRASES)
                .join(MINUS_WORDS)
                .on(PHRASES.MW_ID.eq(MINUS_WORDS.MW_ID))
                .where(PHRASES.PID.eq(pid))
                .fetchOptional()
                .get()
                .value1());
    }

    @Step("DB: получение записи в таблице ppc.minus_words для pid = {0}")
    public MinusWordsRecord getMinusWordsByPid(Long pid) {
        MinusWordsRecord minusWordsRecord = null;
        Long mwId = getPhrases(pid).getMwId();
        if (mwId != null) {
            minusWordsRecord = exec(db -> db.selectFrom(MINUS_WORDS)
                    .where(MINUS_WORDS.MW_ID.eq(mwId))
                    .fetchOne());
        }
        return minusWordsRecord;
    }

    @Step("DB: обновление записи в таблице ppc.minus_words")
    public void updateMinusWords(MinusWordsRecord minusWordsRecord) {
        exec(db -> db.update(MINUS_WORDS)
                .set(minusWordsRecord)
                .where(MINUS_WORDS.MW_ID.eq(minusWordsRecord.getMwId()))
                .execute());
    }

    @Step("DB: выставление типа {1} для группы {0}")
    public void setType(Long pid, PhrasesAdgroupType type) {
        exec(db -> db.update(PHRASES)
                .set(PHRASES.ADGROUP_TYPE, type)
                .where(PHRASES.PID.eq(pid))
                .execute());
    }

    @Step("DB: получение записи в таблице ppc.adgroups_cpm_banner по pid: {0}")
    public AdgroupsCpmBannerRecord getAdgroupsCpmBanner(Long pid) {
        return exec(db -> db.selectFrom(ADGROUPS_CPM_BANNER)
                .where(ADGROUPS_CPM_BANNER.PID.eq(pid))
                .fetchOne()
        );
    }

    @Step("DB: добавление записи в таблице ppc.adgroups_cpm_banner по pid: {0}")
    public void addAdgroupsCpmBanner(Long pid, AdgroupsCpmBannerCriterionType criterionType) {
        run(db -> db.insertInto(ADGROUPS_CPM_BANNER)
                .set(ADGROUPS_CPM_BANNER.PID, pid)
                .set(ADGROUPS_CPM_BANNER.CRITERION_TYPE, criterionType)
                .execute()
        );
    }


    @Step("DB: добавление записи в таблице ppc.adgroups_minus_words pid: {0}, mwId: {1}")
    public void addAdGroupMinusWords(Long pid, Long mwId) {
        run(db -> db.insertInto(ADGROUPS_MINUS_WORDS)
                .set(ADGROUPS_MINUS_WORDS.PID, pid)
                .set(ADGROUPS_MINUS_WORDS.MW_ID, mwId)
                .execute()
        );
    }

    @Step("DB: удаление записи в таблице ppc.adgroups_minus_words pid: {0}, mwId: {1}")
    public void deleteAdGroupMinusWords(Long pid, Long mwId) {
        exec(db -> db.deleteFrom(ADGROUPS_MINUS_WORDS)
                .where(ADGROUPS_MINUS_WORDS.PID.eq(pid)
                        .and(ADGROUPS_MINUS_WORDS.MW_ID.eq(mwId)))
                .execute()
        );
    }

    @Step("DB: добавление записи в таблице ppc.adgroup_priority pid: {0}, mwId: {1}")
    public void addAdGroupPriority(Long pid, Integer priority) {
        run(db -> db.insertInto(ADGROUP_PRIORITY)
                .set(ADGROUP_PRIORITY.PID, pid)
                .set(ADGROUP_PRIORITY.PRIORITY, priority)
                .execute()
        );
    }
}
