package ru.yandex.autotests.direct.db.steps;

import java.util.List;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsTextRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.AdgroupsText.ADGROUPS_TEXT;

public class AdGroupsTextSteps extends BasePpcSteps {

    @Step("DB: получение записей из таблицы ppc.adgroups_text (adgroupId = {0})")
    public List<AdgroupsTextRecord> getAdGroupText(Long adGroupId) {
        return exec(db -> db.selectFrom(ADGROUPS_TEXT)
                .where(ADGROUPS_TEXT.PID.eq(adGroupId))
                .fetch());
    }

}
