package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AddressesRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;

import ru.yandex.qatools.allure.annotations.Step;

import static  ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Addresses.ADDRESSES;

/**
 * Created by hmepas on 14.06.2018
 */
public class AddressesSteps extends BasePpcSteps {
    @Step("DB: Получение записи в таблице ppc.vcards, vid: {0}")
    public AddressesRecord getAddresses(Long aid) {
        return exec(db -> db.selectFrom(ADDRESSES)
                .where(ADDRESSES.AID.eq(aid))
                .fetchOne()
        );
    }
}
