package ru.yandex.autotests.direct.db.steps;


import java.math.BigDecimal;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.DealsAdfoxAdfoxDealStatus;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.DealsAdfoxDealType;
import ru.yandex.autotests.direct.db.steps.base.BasePpcDictSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.DEALS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.DealsDirectDealStatus.Active;
import static ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.DealsAdfox.DEALS_ADFOX;

public class AdfoxSteps extends BasePpcDictSteps {

    @Step("DB: запись в таблицу ppcdict.deals_adfox: сделка {0}, агенство {1}")
    public void addDeal(Long dealId, Long agencyId, DealsAdfoxAdfoxDealStatus dealStatus) {
        exec(db -> db.insertInto(DEALS_ADFOX)
                .set(DEALS_ADFOX.DEAL_ID, dealId)
                .set(DEALS_ADFOX.CLIENTID, agencyId)
                .set(DEALS_ADFOX.ADFOX_DEAL_STATUS, DealsAdfoxAdfoxDealStatus.Active)

                //fake data
                .set(DEALS_ADFOX.ADFOX_NAME, "test_deal")
                .set(DEALS_ADFOX.PUBLISHER_NAME, "bsTransportTests")
                .set(DEALS_ADFOX.ADFOX_DESCRIPTION, "Fake deal")
                .set(DEALS_ADFOX.CONTACTS, "")
                .set(DEALS_ADFOX.TARGETINGS, "")
                .set(DEALS_ADFOX.DEAL_TYPE, DealsAdfoxDealType.preferred_deal)
                .set(DEALS_ADFOX.CPM, BigDecimal.valueOf(1.1))
                .set(DEALS_ADFOX.MISC_ATTRS_JSON, "{}")
                .onDuplicateKeyUpdate()
                .set(DEALS_ADFOX.CLIENTID, agencyId)
                .set(DEALS_ADFOX.ADFOX_DEAL_STATUS, dealStatus)
                .execute());
    }

    @Step("DB: запись в таблицу ppcdict.deals_adfox: сделка {0}, агенство {1} с поданными плейсментами")
    public void addDeal(Long dealId, Long agencyId, String placementsAsJson) {
        exec(db -> db.insertInto(DEALS_ADFOX)
                .set(DEALS_ADFOX.DEAL_ID, dealId)
                .set(DEALS_ADFOX.CLIENTID, agencyId)
                .set(DEALS_ADFOX.ADFOX_DEAL_STATUS, DealsAdfoxAdfoxDealStatus.Active)

                //fake data
                .set(DEALS_ADFOX.ADFOX_NAME, "test_deal")
                .set(DEALS_ADFOX.PUBLISHER_NAME, "bsTransportTests")
                .set(DEALS_ADFOX.ADFOX_DESCRIPTION, "Fake deal")
                .set(DEALS_ADFOX.CONTACTS, "")
                .set(DEALS_ADFOX.TARGETINGS, "")
                .set(DEALS_ADFOX.DEAL_TYPE, DealsAdfoxDealType.preferred_deal)
                .set(DEALS_ADFOX.CPM, BigDecimal.valueOf(1.1))
                .set(DEALS_ADFOX.MISC_ATTRS_JSON, "{}")
                .set(DEALS_ADFOX.PLACEMENTS, placementsAsJson)
                .execute());
    }
}
