package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsDynamicStatusblgenerated;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsDynamicRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUPS_DYNAMIC;
import static ru.yandex.autotests.irt.testutils.allure.AllureUtils.addJsonAttachment;

public class AdgroupsDynamicSteps extends BasePpcSteps {
    @Step("DB: изменение statusBlGenerated группы с (id = {0}, status = {1})")
    public void setStatusBlGenerated(long pid, AdgroupsDynamicStatusblgenerated statusblgenerated) {
        run(db -> db.update(ADGROUPS_DYNAMIC)
                .set(ADGROUPS_DYNAMIC.STATUSBLGENERATED, statusblgenerated)
                .where(ADGROUPS_DYNAMIC.PID.eq(pid))
                .execute());
    }

    @Step("DB: получение записи из таблицы ppc.adgroups_dynamic(pid = {0})")
    public AdgroupsDynamicRecord getAdgroupsDynamic(long pid) {
        AdgroupsDynamicRecord retVal = exec(db -> db.selectFrom(ADGROUPS_DYNAMIC)
                .where(ADGROUPS_DYNAMIC.PID.eq(pid))
                .fetchAny());
        String logRecord = retVal == null ? "null" : JsonUtils.toStringLow(retVal.intoMap());
        getLogger().info("Получена запись из таблицы ppc.adgroups_dynamic: " + logRecord);
        addJsonAttachment("Получена запись", logRecord);
        return retVal;
    }

    @Step("DB: изменение полей use_as группы с (id = {0}, useAsName = {1}, useAsBody = {2})")
    public void setUseAsFieldsDynamic(long pid, String useAsName, String useAsBody) {
        run(db -> db.update(ADGROUPS_DYNAMIC)
                .set(ADGROUPS_DYNAMIC.FIELD_TO_USE_AS_NAME, useAsName)
                .set(ADGROUPS_DYNAMIC.FIELD_TO_USE_AS_BODY, useAsBody)
                .where(ADGROUPS_DYNAMIC.PID.eq(pid))
                .execute());
    }
}
