package ru.yandex.autotests.direct.db.steps;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsPerformanceStatusblgenerated;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsPerformanceRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.ADGROUPS_PERFORMANCE;
import static ru.yandex.autotests.irt.testutils.allure.AllureUtils.addJsonAttachment;

public class AdgroupsPerformanceSteps extends BasePpcSteps {
    @Step("DB: удаление записи из таблицы ppc.adgroups_performance (pid = {0})")
    public void deleteAdgroupsPerformance(long pid) {
        run(db -> db.deleteFrom(ADGROUPS_PERFORMANCE)
                .where(ADGROUPS_PERFORMANCE.PID.eq(pid))
                .execute());
    }

    @Step("DB: создание записи в таблице ppc.adgroups_performance")
    public AdgroupsPerformanceRecord saveAdgroupsPerformance(AdgroupsPerformanceRecord adgroupsPerformanceRecord) {
        String logRecord = JsonUtils.toStringLow(adgroupsPerformanceRecord.intoMap());
        getLogger().info("новая запись в таблице ppc.adgroups_performance: " + logRecord);
        addJsonAttachment("новая запись", logRecord);
        return exec(db -> db.insertInto(ADGROUPS_PERFORMANCE)
                .set(adgroupsPerformanceRecord)
                .returning()
                .fetchOne());
    }

    @Step("DB: создание записи в таблице ppc.adgroups_performance (pid = {0}, feedId = {1})")
    public AdgroupsPerformanceRecord saveAdgroupsPerformance(long pid, long feedId) {
        AdgroupsPerformanceRecord adgroupsPerformanceRecord = new AdgroupsPerformanceRecord()
                .setPid(pid)
                .setFeedId(feedId)
                .setStatusblgenerated(AdgroupsPerformanceStatusblgenerated.No);
        return saveAdgroupsPerformance(adgroupsPerformanceRecord);
    }

    @Step("DB: изменение statusBlGenerated группы с (id = {0}, status = {1})")
    public void setStatusBlGenerated(long pid, AdgroupsPerformanceStatusblgenerated statusblgenerated) {
        run(db -> db.update(ADGROUPS_PERFORMANCE)
                .set(ADGROUPS_PERFORMANCE.STATUSBLGENERATED, statusblgenerated)
                .where(ADGROUPS_PERFORMANCE.PID.eq(pid))
                .execute());
    }
}
