package ru.yandex.autotests.direct.db.steps;

import java.math.BigInteger;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AgencyClientProveRecord;
import ru.yandex.autotests.direct.db.steps.base.BasePpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.AgencyClientProve.AGENCY_CLIENT_PROVE;

/**
 * Created by lightelfik on 22.10.19.
 */
public class AgencyClientProveSteps extends BasePpcSteps {

    @Step("DB: удаление записи из таблицы ppc.agency_client_prove для агенства {0} и клиента {1}")
    public void deleteAgencyClientProveIfExists(Long agencyClientId, Long clientUid) {
        AgencyClientProveRecord record = getAgencyClientProve(agencyClientId, clientUid);
        if (record != null) {
            exec(db -> db.deleteFrom(AGENCY_CLIENT_PROVE)
                    .where(      AGENCY_CLIENT_PROVE.CLIENT_UID.eq(record.getClientUid())
                            .and(AGENCY_CLIENT_PROVE.AGENCY_CLIENT_ID.eq(record.getAgencyClientId())))
                    .execute());
        }
    }

    @Step("DB: получение записи о запросе от агенства {0} пользователю {1} из таблицы ppc.agency_client_prove")
    public AgencyClientProveRecord getAgencyClientProve(Long agencyClientId, Long clientUid) {
        return exec(db -> db.selectFrom(AGENCY_CLIENT_PROVE)
                .where(      AGENCY_CLIENT_PROVE.CLIENT_UID.eq(BigInteger.valueOf(clientUid))
                        .and(AGENCY_CLIENT_PROVE.AGENCY_CLIENT_ID.eq(agencyClientId)))
                .fetchOne());
    }
}
